import React from 'react'
import Link from 'next/link';
import Image from 'next/image';


const Lettercard = ({ letter }) => {
    return (
        <div className="col-lg-3 col-12">
            <div className='cards h-100'>
                {/* <Image src={letter.media_url} width={306} height={427} className="card-img-top" alt="..." /> */}
                <Image
                    key={letter?.media_url}
                    src={letter?.media_url} // Use optional chaining here
                    width={306}
                    height={427}
                    className="card-img-top"
                    alt="Newsletter Image"
                />
                <div className="card-body">
                    {/* Add a conditional check for 'letter.newsletter_title' */}
                    {letter && letter.newsletter_title ? (
                        <h5 className="card-title mt-2 fw-bold">{letter.newsletter_title}</h5>
                    ) : (
                        <h5 className="card-title mt-2 fw-bold">Title Not Available</h5>
                    )}
                    {/* <h5 className="card-title mt-2 fw-bold">{letter.newsletter_title}</h5> */}
                </div>
                <div className='mt-3'>
                    <ul className="d-flex list-unstyled mt-auto">
                        {/* <li className="me-auto">
                        <Link href={`/newsletter/[id]`} as={`/newsletter/${letter.newsletter_meta}`} className="btn btn-outline-danger">View Complete Issue</Link>
                        </li> */}
                        <li className="d-flex align-items-center">
                            {letter && letter.pdf_url ? (
                                <Link target='_blank' href={letter.pdf_url} className="btn btn-outline-danger"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" className="bi bi-box-arrow-down" viewBox="0 0 16 16">
                                    <path fillRule="evenodd" d="M3.5 10a.5.5 0 0 1-.5-.5v-8a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 .5.5v8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 0 0 1h2A1.5 1.5 0 0 0 14 9.5v-8A1.5 1.5 0 0 0 12.5 0h-9A1.5 1.5 0 0 0 2 1.5v8A1.5 1.5 0 0 0 3.5 11h2a.5.5 0 0 0 0-1h-2z" />
                                    <path fillRule="evenodd" d="M7.646 15.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 14.293V5.5a.5.5 0 0 0-1 0v8.793l-2.146-2.147a.5.5 0 0 0-.708.708l3 3z" />
                                </svg></Link>
                            ) : (
                                // Handle the case when pdf_url is undefined
                                null // Or any other fallback UI or message you want to display
                            )}
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    )
}

export default Lettercard