import React from 'react'

import Head from 'next/head'
import Layoutdps from '../_layoutdps';
import Qhseheading from '../../components/DpsQhse/qhseheading';
import Qhseintro from '../../components/DpsQhse/qhseintro';
import dynamic from 'next/dynamic';
const Strategyintro = dynamic(() => import('../../components/DpsQhse/strategy'));

const Qshse = () => {
  return (
    <>

      <Head>
        <title>Descon Power Solutions - QHSE  | Descon</title>
        <meta name="description" content="DPS Integrated Management System (IMS) is a centralized framework that we use to manage QHSE standards across our operations and maintenance (O&M) activities." key="desc" />
        <meta property="og:title" content=">Descon Power Solutions - QHSE" />
        <meta property="og:description" content="DPS Integrated Management System (IMS) is a centralized framework that we use to manage QHSE standards across our operations and maintenance (O&M) activities." />
        <meta property="og:image" content="'/assets/dps/qhse/qhse-bg.png" />
      </Head>
      <Layoutdps>
        <Qhseheading />
        <Qhseintro />
        <Strategyintro />
      </Layoutdps>

    </>
  )
}

export default Qshse