import React from 'react';
import Link from 'next/link';
import Image from 'next/image';

const Notices = ({ notice, isVisible }) => {
    if (!notice || !notice.file_name) {
        // Check if 'notice' is undefined or 'file_name' is missing
        return <div>Error: Invalid notice data</div>;
    }

    return (
        <div className={`pdfsspacers ${isVisible ? 'visible' : 'hidden'}`}>
            <Link target='_blank' href={notice.file_name}>
                <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={416} height={227} layout='responsive' />
                <p className='mb-2 mt-3'>{notice.title}</p>
            </Link>
        </div>
    );
};

export default Notices;






