import React, { useEffect, useState } from 'react';
import axios from 'axios';
import Image from 'next/image';
import { Tab, Nav } from 'react-bootstrap';
import Head from 'next/head';
import Layoutdol from '../../_layoutdol';
import Dolcompanyheading from '../../../components/Dolcompanyinfo/companyheading';
import Anuualreport from './anuualreport';
import Halfyearlyreport from './halfyearlyreport ';
import Quarterlyreport from './quarterlyreport';
import CompanyGovernance from '../../../components/Dolcompanyinfo/company-profile';
import ShareHolding from './shareholding';
import Investorrelations from '../../../components/Dolcompanyinfo/Investor-relations';
import Compliancecertificate from './compliancecertificate';
import Financialratios from './financialratio';
import Notices from './notice';
import Investorprestation from './investor';
import Otherinfo from './otherinfo';
import Dolcompinfointro from '../../../components/Dolcompanyinfo/dolcompinfointro';
import Companydetails from '../../../components/Dolcompanyinfo/companydetails';
import dynamic from 'next/dynamic';
const OwlCarousel = dynamic(() => import('react-owl-carousel'), {
    ssr: false, // Use `fallback` instead of `loading`
    key: Date.now(),
});
import 'owl.carousel/dist/assets/owl.carousel.css';
import 'owl.carousel/dist/assets/owl.theme.default.css';




const Companyprofile = ({ anuualreport, halfyearreport, quarteryearreport, sharesholder, certificate, ratio, noticereport, invest, info }) => {

    const [report, setReport] = useState(anuualreport);
    const [halfreport, setHalfreport] = useState(halfyearreport);
    const [quaterreport, setQuaterreport] = useState(quarteryearreport);
    const [shares, setSharesreport] = useState(sharesholder);
    const [compliance, setCompliance] = useState(certificate);
    const [financial, setFinancial] = useState(ratio);
    const [notices, setNotices] = useState(noticereport);
    const [investor, setInvestor] = useState(invest);
    const [others, setOthers] = useState(info);
    const [loading, setLoading] = useState(true);
    // ============Companiy PRofile===========
    useEffect(() => {
        if (sharesholder?.length > 0) {
            setLoading(false)
            setSharesreport(sharesholder)
        }
    }, [sharesholder])
    // =================XXXX==========

    // ================Investor Relations=============
    useEffect(() => {
        if (certificate?.length > 0) {
            setLoading(false)
            setCompliance(certificate)
        }
    }, [certificate])

    useEffect(() => {
        if (ratio?.length > 0) {
            setLoading(false)
            setFinancial(ratio)
        }
    }, [ratio])


    useEffect(() => {
        if (noticereport?.length > 0) {
            setLoading(false)
            setNotices(noticereport)
        }
    }, [noticereport])


    useEffect(() => {
        if (invest?.length > 0) {
            setLoading(false)
            setInvestor(invest)
        }
    }, [invest])

    useEffect(() => {
        if (info?.length > 0) {
            setLoading(false)
            setOthers(info)
        }
    }, [info])

    // ===========financial statement=================
    useEffect(() => {
        if (anuualreport?.length > 0) {
            setLoading(false)
            setReport(anuualreport);
        }
    }, [anuualreport])


    useEffect(() => {
        if (halfyearreport?.length > 0) {
            setLoading(false)
            setHalfreport(halfyearreport)
        }
    }, [halfyearreport])

    useEffect(() => {
        if (quarteryearreport?.length > 0) {
            setLoading(false)
            setQuaterreport(quarteryearreport)
        }
    }, [quarteryearreport])
    // =================XXXXX=========================



    const [visibleCount, setVisibleCount] = useState(6);

    const handleReadMore = () => {
        setVisibleCount(notices.length); // Show all notices
    };

    const handleReduce = () => {
        setVisibleCount(6); // Show only 5 notices
    };

    // ====owl carousel reports ==============
    const owlOptions = {
        loop: true,
        margin: 10,
        nav: true, // Show navigation arrows
        dots: true, // Show dots
        responsive: {
            0: {
                items: 1,
            },
            600: {
                items: 3,
            },
            1000: {
                items: 6,
            },
        },
    };

    return (
        <>
            <Head>
                <title>Descon Oxychem - Company Information | Descon</title>
                <meta name="description" content="We at Descon know and believe that our employees are our biggest assets. It is their passion and dedication that has been the driving force behind all our successes in the last three decades." key="desc" />
                <meta property="og:title" content="Descon Oxychem - Careers" />
                <meta property="og:description" content="We at Descon know and believe that our employees are our biggest assets. It is their passion and dedication that has been the driving force behind all our successes in the last three decades." />
                <meta property="og:image" content="/assets/career.jpg" />
            </Head>
            <Layoutdol>
                <Dolcompanyheading />
                <Dolcompinfointro />
                <CompanyGovernance />
                <Companydetails />
                <div className='container-fluid'>
                    <div className='row '>
                        <div className='col-12 mt-5 '>
                            <p className='biggerfonts text-end' >Share Holding Pattern</p>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust'>
                            <h1 className='text-center'>Share Holding Pattern</h1>
                            <div className="container-fluid">
                                <div className="row" >
                                    {shares && shares.length > 0 ? (

                                        shares.slice(0, shares.length - 0).map((shares, index) => {
                                            return (
                                                <>
                                                    <div className="col-lg-4 col-6 ">
                                                        <ShareHolding key={index} shares={shares} />
                                                    </div>
                                                </>
                                            )
                                        })
                                    ) : (
                                        <div className="text-center">
                                            <Image src="/loading-51.gif" alt="Loading..." width={80} height={80} style={{

                                            }} />
                                        </div>
                                    )
                                    }
                                </div>
                            </div>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                            <div className='img-fluid image4' style={{ zIndex: "2" }}>
                                <Image src='/assets/dol/company-info/shares.png' width={940} height={560} layout='responsive' alt='committment' className='img-fluid' />
                            </div>
                        </div>

                    </div>
                    <div className="container spacer">
                        <div className="row ">
                            <div className="col-lg-8 col-12">
                                <h5 className='subtitle'>Investor Relations</h5>
                                <h1 className="title">Streamlined IR <br />insights for <br />investors.</h1>
                            </div>
                            <div className="col-lg-4 col-12">
                                <Image src='/assets/dol/company-info/profilegovernance/abdul-sohail.png' alt="homepage news" className=' img-fluid mt-4' width={300} height={227} />
                                <h6
                                    className='fw-bold fs-6 text-decoration-none text-dark pt-4'>
                                    <div>
                                        Abdul Sohail
                                    </div>
                                </h6>
                                <p className='mt-3'>Company Secretary</p>
                            </div>
                        </div>
                    </div>
                    <div className='row mb-5'>
                        <div className='col-12'>
                            <p className='biggerfonts' >Financial Highlitgts</p>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                            <div className='img-fluid image4' style={{ zIndex: "2" }}>
                                <Image src='/assets/dol/company-info/ratio.png' width={940} height={560} layout='responsive' alt='adopting' className='img-fluid' />
                            </div>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                            <h1 className='text-center'>Financial Highlights & Ratios</h1>
                            <div className="container-fluid">
                                <div className="row" >
                                    {financial && financial.length > 0 ? (

                                        financial.slice(0, financial.length - 0).map((financial, index) => {
                                            return (
                                                <>
                                                    <div className="col-lg-4 col-6 ">
                                                        <Financialratios key={index} financial={financial} />
                                                    </div>
                                                </>
                                            )
                                        })
                                    ) : (
                                        <div className="text-center">
                                            <Image src="/loading-51.gif" alt="Loading..." width={80} height={80} style={{

                                            }} />
                                        </div>
                                    )
                                    }
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className='row mb-5'>
                        <div className='col-12 mt-5 '>
                            <p className='biggerfonts text-end' >Notices</p>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                            <h1 className='text-center'>Notices</h1>
                            <div className="container-fluid">
                                <div className="row" >
                                    {notices && notices.length > 0 ? (
                                        notices.slice(0, visibleCount).map((notice, index) => (
                                            <div key={index} className="col-lg-4 col-6">
                                                <Notices notice={notice} isVisible={index < visibleCount} />
                                            </div>
                                        ))
                                    ) : (
                                        <div className="text-center">
                                            Loading...
                                        </div>
                                    )}
                                    {notices.length > 6 && visibleCount === 6 && (
                                        <button onClick={handleReadMore} className="button-more read">
                                            Read More
                                        </button>
                                    )}

                                    {visibleCount > 6 && (
                                        <button onClick={handleReduce} className="button-more read">
                                            Reduce
                                        </button>
                                    )}
                                </div>
                            </div>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                            <div className='img-fluid image4' style={{ zIndex: "2" }}>
                                <Image src='/assets/dol/company-info/shares.png' width={940} height={560} layout='responsive' alt='committment' className='img-fluid' />
                            </div>
                        </div>

                    </div>
                    <div className='row mb-5'>
                        <div className='col-12'>
                            <p className='certificatefonts' >Compliance Certificate &  Election of Directors</p>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                            <div className='img-fluid image4' style={{ zIndex: "2" }}>
                                <Image src='/assets/dol/company-info/certificate.png' width={940} height={560} layout='responsive' alt='adopting' className='img-fluid' />
                            </div>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                            <h1>Compliance Certificate & Election of Directors</h1>
                            <div className="container-fluid">
                                <div className="row" >
                                    {compliance && compliance.length > 0 ? (

                                        compliance.slice(0, compliance.length - 0).map((compliance, index) => {
                                            return (
                                                <>
                                                    <div className="col-lg-4 col-6 mb-5 pt-4">
                                                        <Compliancecertificate key={index} compliance={compliance} />
                                                    </div>
                                                </>
                                            )
                                        })
                                    ) : (
                                        <div className="text-center">
                                            <Image src="/loading-51.gif" alt="Loading..." width={80} height={80} style={{

                                            }} />
                                        </div>
                                    )
                                    }
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <Investorrelations />
                <div className='container-fluid'>
                    {/* ========================Investor Presentations============================ */}
                    <div className='row mb-5'>
                        <div className='col-12'>
                            <p className='biggerfonts' >Investor Presentations</p>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                            <div className='img-fluid image4' style={{ zIndex: "2" }}>
                                <Image src='/assets/dol/company-info/investor.png' width={940} height={560} layout='responsive' alt='adopting' className='img-fluid' />
                            </div>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                            <h1 className='text-center'>Investor Presentations</h1>
                            <div className="container-fluid">
                                <div className="row" >
                                    {investor && investor.length > 0 ? (

                                        investor.slice(0, investor.length - 0).map((investor, index) => {
                                            return (
                                                <>
                                                    <div className="col-lg-4 col-6 ">
                                                        <Investorprestation key={index} investor={investor} />
                                                    </div>
                                                </>
                                            )
                                        })
                                    ) : (
                                        <div className="text-center">
                                            <Image src="/loading-51.gif" alt="Loading..." width={80} height={80} style={{

                                            }} />
                                        </div>
                                    )
                                    }
                                </div>
                            </div>
                        </div>
                    </div>
                    {/* =========================Other Information====================================== */}
                    <div className='row mb-5'>
                        <div className='col-12 mt-5 '>
                            <p className='biggerfonts text-end' >Other Information</p>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                            <h1 className='text-center'>Other Information</h1>
                            <div className="container-fluid">
                                <div className="row" >
                                    {others && others.length > 0 ? (

                                        others.slice(0, others.length - 0).map((others, index) => {
                                            return (
                                                <>
                                                    <div className="col-lg-4 col-6">
                                                        <Otherinfo key={index} others={others} />
                                                    </div>
                                                </>
                                            )
                                        })
                                    ) : (
                                        <div className="text-center">
                                            <Image src="/loading-51.gif" alt="Loading..." width={80} height={80} style={{

                                            }} />
                                        </div>
                                    )
                                    }
                                </div>

                            </div>
                        </div>
                        <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                            <div className='img-fluid image4' style={{ zIndex: "2" }}>
                                <Image src='/assets/dol/company-info/otherinfo.png' width={940} height={560} layout='responsive' alt='committment' className='img-fluid' />
                            </div>
                        </div>
                    </div>
                </div>
                <div className='col-12 mt-5 bg-color'>
                    <div className='container-fluid'>
                        <div className="row">
                            <div className='col-xxl-9 col-xl-6 col-xs-9 col-md-9 col-lg-12  col-12 panel-leftright-adjusts'>
                                {/* ==================Annual================== */}
                                <div className='mt-5'>
                                    <h5 className='fw-bold mx-3'>Annual</h5>
                                    <OwlCarousel className="owl-theme" {...owlOptions}>
                                        {report && report.length > 0 ? (
                                            report.map((report, index) => (
                                                <div key={index} className="item">
                                                    <Anuualreport report={report} />
                                                </div>
                                            ))
                                        ) : (
                                            <div className="text-center">
                                                Loading...
                                            </div>
                                        )}
                                    </OwlCarousel>
                                </div>
                                {/* =========================Half Yearly============= */}
                                <div className='mt-5'>
                                    <h5 className='fw-bold mx-3'>Half Yearly</h5>
                                    <OwlCarousel className="owl-theme" {...owlOptions}>
                                        {halfreport && halfreport.length > 0 ? (
                                            halfreport.map((halfreport, index) => (
                                                <div key={index} className="item">
                                                    <Halfyearlyreport halfreport={halfreport} />
                                                </div>
                                            ))
                                        ) : (
                                            <div className="text-center">
                                                Loading...
                                            </div>
                                        )}
                                    </OwlCarousel>
                                </div>
                                {/* ================Quarterly=========== */}
                                <div className='mt-5 pb-5'>
                                    <h5 className='fw-bold mx-3'>Quarterly</h5>
                                    <OwlCarousel className="owl-theme" {...owlOptions}>
                                        {quaterreport && quaterreport.length > 0 ? (
                                            quaterreport.map((quaterreport, index) => (
                                                <div key={index} className="item">
                                                    <Quarterlyreport quaterreport={quaterreport} />
                                                </div>
                                            ))
                                        ) : (
                                            <div className="text-center">
                                                Loading...
                                            </div>
                                        )}
                                    </OwlCarousel>
                                </div>
                            </div>
                            <div className='col-xxl-3 col-xl-6 col-xs-3 col-md-3 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                                <div className='img-fluid mt-5' style={{ zIndex: "2" }}>
                                    <Image src='/assets/dol/company-info/allreports.png' width={940} height={560} layout='responsive' alt='committment' className='img-fluid mt-5' />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </Layoutdol >
        </>
    );
};


const convertToHtml = (reportData) => {
    return reportData.map(reports => `
      <div className="news-item">
        <h3>${reports.news_title}</h3>
        <p>${reports.news_description}</p>
        <span>${reports.news_date}</span>
      </div>
    `).join('');
};



export const getStaticProps = async () => {
    try {
        const responsshares = await axios.get("https://descon.com/en/rest-api/company_info/read.php?info_block=shp");
        const sortedshares = responsshares.data.data.sort((a, b) => {
            const dateA = new Date(a.sharesholder_date);
            const dateB = new Date(b.sharesholder_date);
            return dateB - dateA;
        });
        const responscompliance = await axios.get("https://descon.com/en/rest-api/company_info/read.php?info_block=direc,cmpcr");
        const sortedcompliance = responscompliance.data.data.sort((a, b) => {
            const dateA = new Date(a.certificate_date);
            const dateB = new Date(b.certificate_date);
            return dateB - dateA;
        });
        // ============XXXX================
        const responsefinancial = await axios.get("https://descon.com/en/rest-api/company_info/read.php?info_block=finhi");
        const sortedratio = responsefinancial.data.data.sort((a, b) => {
            const dateA = new Date(a.ratio_date);
            const dateB = new Date(b.ratio_date);
            return dateB - dateA;
        });
        const responsenotices = await axios.get("https://descon.com/en/rest-api/company_info/read.php?info_block=notic");
        const sortednotice = responsenotices.data.data.sort((a, b) => {
            const dateA = new Date(a.noticereport_date);
            const dateB = new Date(b.noticereport_date);
            return dateB - dateA;
        });
        const responseinvestor = await axios.get("https://descon.com/en/rest-api/company_info/read.php?info_block=invpr");
        const sortedinvestor = responseinvestor.data.data.sort((a, b) => {
            const dateA = new Date(a.invest_date);
            const dateB = new Date(b.invest_date);
            return dateB - dateA;
        });
        const responseothers = await axios.get("https://descon.com/en/rest-api/company_info/read.php?info_block=other");
        const sortedother = responseothers.data.data.sort((a, b) => {
            const dateA = new Date(a.info_date);
            const dateB = new Date(b.info_date);
            return dateB - dateA;
        });

        // ============XXXX================
        const responsereport = await axios.get("https://descon.com/en/rest-api/company_info/read.php?info_block=annual");
        const sortedreport = responsereport.data.data.sort((a, b) => {
            const dateA = new Date(a.anuualreport_date);
            const dateB = new Date(b.anuualreport_date);
            return dateB - dateA;
        });
        const responsehalfyearlyreport = await axios.get("https://descon.com/en/rest-api/company_info/read.php?info_block=half-year");
        const sortedhalfreport = responsehalfyearlyreport.data.data.sort((a, b) => {
            const dateA = new Date(a.halfyearreport_date);
            const dateB = new Date(b.halfyearreport_date);
            return dateB - dateA;
        });
        const responsequaterlyreport = await axios.get("https://descon.com/en/rest-api/company_info/read.php?info_block=quarterly");
        const sortedquaterreport = responsequaterlyreport.data.data.sort((a, b) => {
            const dateA = new Date(a.quarteryearreport_date);
            const dateB = new Date(b.quarteryearreport_date);
            return dateB - dateA;
        });

        const htmlData = convertToHtml(sortedshares, sortedcompliance, sortedratio, sortednotice, sortedinvestor, sortedother, sortedreport, sortedhalfreport, sortedquaterreport);
        return {
            props: {
                sharesholder: sortedshares,
                certificate: sortedcompliance,
                ratio: sortedratio,
                noticereport: sortednotice,
                invest: sortedinvestor,
                info: sortedother,
                anuualreport: sortedreport,
                halfyearreport: sortedhalfreport,
                quarteryearreport: sortedquaterreport,
                htmlData: htmlData,
            }
        };
    } catch (error) {
        console.error("Error fetching news:", error);
        return {
            props: {
                sharesholder: [],
                certificate: [],
                ratio: [],
                noticereport: [],
                invest: [],
                info: [],
                anuualreport: [],
                halfyearreport: [],
                quarteryearreport: [],
                htmlData: '', // Return an empty array if there's an error
            }
        };
    }
};

export default Companyprofile