import React from 'react'
import Link from 'next/link';
import Image from 'next/image';

const Otherinfo = ({  others }) => {
    if (!others || !others.file_name) {
        // Check if 'others' is undefined or 'file_name' is missing
        return <div>Error: Invalid others data</div>;
    }

    return (
        <div className='pdfsspacers'>
            <Link target='_blank' href={others.file_name}>
                <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={416} height={227} layout='responsive' />
                <p className='mb-2 mt-3'>{others.title}</p>
            </Link>
        </div>
    )
}

export default Otherinfo;
