import React from 'react'
import Link from 'next/link';
import Image from 'next/image';

const Financialratios = ({  financial }) => {
    if (!financial || !financial.file_name) {
        // Check if 'financial' is undefined or 'file_name' is missing
        return <div>Error: Invalid financial data</div>;
    }

    return (
        <div className='pdfsspacers'>
            <Link target='_blank' href={financial.file_name}>
                <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={416} height={227} layout='responsive' />
                <p className='mb-2 mt-3'>{financial.title}</p>
            </Link>
        </div>
    )
}

export default Financialratios;
