import React, { useEffect, useState } from 'react'

import Head from 'next/head'
import Dolheading from '../../components/DOLurdu/dolheading'
import Dolintro from '../../components/DOLurdu/dolintro'
import dynamic from 'next/dynamic';
import Layoutdol from '../_layoutdol';
import axios from 'axios';
import Image from 'next/image';
import Teammembers from './team';
import Boadofdirector from './bod';
import Layoutdolurdu from '../_layoutdolurdu';
const Ceomessage = dynamic(() => import('../../components/DOLurdu/ceomessage'));
const Missionintro = dynamic(() => import('../../components/DOLurdu/missionintro'));
const Boardofdirectors = dynamic(() => import('../../components/DOLurdu/boardofdirectors'));
const Leadership = dynamic(() => import('../../components/DOLurdu/leadership'));


const DOL = ({ leaders, htmlData, bod }) => {


  const [membersx, setMembers] = useState(leaders);
  const [director, setDirector] = useState(bod);
  const [loading, setLoading] = useState(true);
  // const [showMore] = useState(false);

  useEffect(() => {
    if (leaders?.length > 0) {
      setLoading(false)
      setMembers(leaders)
    }
  }, [leaders]);


  useEffect(() => {
    if (bod?.length > 0) {
      setLoading(false)
      setDirector(bod)
    }
  }, [bod]);


  // const teamToShow = showMore ? membersx : (membersx ? membersx.slice(0, 3) : []);
  return (
    <>
      <Head>
        <title>Descon Oxychem - About  | Descon</title>
        <meta name="description" content="Descon Oxychem has rapidly evolved to become the market leader in an intensely competitive Hydrogen Peroxide domestic market." key="desc" />
        <meta property="og:title" content="Descon Oxychem - About " />
        <meta property="og:description" content="Descon Oxychem has rapidly evolved to become the market leader in an intensely competitive Hydrogen Peroxide domestic market." />
        <meta property="og:image" content="'/assets/dol/about/dol-bg.png" />
      </Head>
      <Layoutdolurdu>
        <Dolheading />
        <Dolintro />
        <Ceomessage />
        <Missionintro />
        {/* <Boardofdirectors /> */}
        <div className="bg-light boardofdirector">
          <div className="container text-center">
            <div className='mb-5 col-md-8 mx-auto'>
              <h1> بورڈ آف ڈائریکٹرز</h1>
              <p style={{
                lineHeight: "1.5",
                fontSize: "17px",
              }}>ڈیسکون آکسیکیم کے بورڈ آف ڈائریکٹرز کی اجتماعی ذمہ داری ہے کہ وہ اس بات کو یقینی بنائے کہ کمپنی کے معاملات کو قابلیت اور دیانتداری کے ساتھ منظم انداز سے چلایا جائے۔</p>
            </div>
            <div className="row align-items-center text-center bod rtl">
              {
                loading ? (
                  <div className="text-center">
                    {/* <Image
                      src="/assets/loading-51.gif"
                      alt="Loading..."
                      width={80}
                      height={80}
                    /> */}
                  </div>
                ) : director && director.length > 0 ? (
                  director.map((bod, index) => {
                    return (
                      <Boadofdirector
                        key={index}
                        bod={bod}
                      />
                    )
                  })
                ) : (
                  <div className="text-center" dangerouslySetInnerHTML={{ __html: htmlData }} />
                )
              }
            </div >
          </div >
        </div >
        {/* <Leadership /> */}
        <div className='bg-leadership p-5 position-relative'>
          <div className='mb-5 col-md-10 mx-auto rtl'>
            <h1>لیڈر شپ  ٹیم</h1>
            <p className='text-white' style={{
              lineHeight: "1.5",
              fontSize: "17px",
            }}>ڈیسکون آکسیکیم کی لیڈر شپ ٹیم قابل اور تجربہ کار افراد پر مشتمل ہے۔ وہ ہمارے اہداف کا تعین  اور اُن کی وضاحت  کے ذمہ دار ہیں جو ہمیں طے شدہ مقاصد کے حصول کےلئے ایک پلیٹ فارم پر مجتمع  کریں گے۔ وہ ڈیسکون کی اقدار اور وژن کے مستحکم عزم  کے ساتھ کمپنی کی قیادت کرتے ہیں۔</p>
          </div>
          <div className="box-leadership ">
            <div className="container">
              <div className="row align-items-center text-center bod rtl">
                {
                  loading ? (
                    <div className="text-center">
                      {/* <Image
                        src="/assets/loading-51.gif"
                        alt="Loading..."
                        width={80}
                        height={80}
                      /> */}
                    </div>
                  ) : membersx && membersx.length > 0 ? (
                    membersx.map((members, index) => {
                      return (
                        <Teammembers
                          key={index}
                          members={members}
                        />
                      )
                    })
                  ) : (
                    <div className="text-center" dangerouslySetInnerHTML={{ __html: htmlData }} />
                  )
                }
              </div >
            </div >
          </div >
        </div >
      </Layoutdolurdu>
    </>
  )
}


// const convertToHtml = (membersData) => {
//   return membersData.map(members => `
//         <div class="members-item">
//           <h3>${members.team_name}</h3>
//           <p>${members.team_desig}</p>
//           <span>${members.timestamp}</span>
//         </div>
//         `).join('');
// };

// export const getStaticProps = async () => {
//   try {
//     const response1 = await axios.get("https://descon.com/en/rest-api/teams/read.php?verticals=dol&view_status=y&type_of_team=leader");
//     let sortedTeam = response1.data.data.sort((a, b) => {
//       const dateA = new Date(a.timestamp);
//       const dateB = new Date(b.timestamp);
//       return dateB - dateA;
//     });

//     const response2 = await axios.get("https://descon.com/en/rest-api/teams/read.php?verticals=dol&view_status=y&type_of_team=bod");
//     let sortedbod = response2.data.data.sort((a, b) => {
//       const dateA = new Date(a.timestamp);
//       const dateB = new Date(b.timestamp);
//       return dateB - dateA;
//     });

//     sortedTeam = sortedTeam.reverse();
//     sortedbod = sortedbod.reverse();

//     const htmlData1 = convertToHtml(sortedTeam);
//     const htmlData2 = convertToHtml(sortedbod);

//     return {
//       props: {
//         leaders: sortedTeam,
//         bod: sortedbod,
//         htmlData: htmlData1,
//       }
//     };
//   } catch (error) {
//     console.error("Error fetching members:", error);
//     return {
//       props: {
//         leaders: [],
//         bod: [],
//         htmlData: '', // Return an empty array if there&apos;s an error
//       }
//     };
//   }
// };

export async function getStaticProps() {
  const response1 = require('./urdu-team/dol-urdu-bod.json'); // Ensure correct path
  const response2 = require('./urdu-team/dol-urdu-team.json'); // Ensure correct path
  return {
    props: {
      bod: response1.data, // Correctly pass the `leaders` array
      leaders: response2.data, // Correctly pass the `leaders` array
    },
  };
}


export default DOL