import Image from 'next/image';
import Link from 'next/link';
import React from 'react';

const Teammembers = ({ members, maxDescriptionLength = 250 }) => {
    if (!members) {
        // Handle the case when members is undefined or null
        return null; // Or any other fallback UI or message you want to display
    }


    const stripHtmlTags = (htmlString) => {
        const doc = new DOMParser().parseFromString(htmlString, 'text/html');
        return doc.body.textContent || '';
    };

    const cleanedDescription = stripHtmlTags(members.team_desc);

    cleanedDescription.length > maxDescriptionLength


    // const truncatedDescription =
    //     cleanedDescription.length > maxDescriptionLength
    //         ? cleanedDescription.slice(0, maxDescriptionLength - 4) + '...'
    //         : cleanedDescription;

    // const titleLines = isFirstCard ? 1.5 : 2;
    // const titleMaxHeight = 1.3 * titleLines + 'em';


    return (
        <>
            <div className="col-lg-3 col mb-5 position-relative"  style={{zIndex:"1"}}>
                <Link className='text-decoration-none' href={'/del/team/[id]'} as={`/del/team/${encodeURIComponent(members.team_meta)}`}>
                    <Image src={members.team_image_url} alt="homepage members" className='mb-3' height={180} width={500} />
                    <div className='m6'>
                        <p className='fs-6 fw-bold'>{members.team_name}</p>
                        <p>{members.team_desig}</p>
                    </div>
                </Link>
            </div>
        </>
    )
}

export default Teammembers;
