import Image from 'next/image';
import Link from 'next/link';
import React from 'react';

const Boadofdirector = ({ bod, maxDescriptionLength = 250 }) => {
    if (!bod) {
        // Handle the case when bod is undefined or null
        return null; // Or any other fallback UI or message you want to display
    }


    const stripHtmlTags = (htmlString) => {
        const doc = new DOMParser().parseFromString(htmlString, 'text/html');
        return doc.body.textContent || '';
    };

    const cleanedDescription = stripHtmlTags(bod.team_desc);

    cleanedDescription.length > maxDescriptionLength


    // const truncatedDescription =
    //     cleanedDescription.length > maxDescriptionLength
    //         ? cleanedDescription.slice(0, maxDescriptionLength - 4) + '...'
    //         : cleanedDescription;

    // const titleLines = isFirstCard ? 1.5 : 2;
    // const titleMaxHeight = 1.3 * titleLines + 'em';


    return (
        <>
            <div className="col-lg-3 col mb-5">
                <Link className='text-decoration-none' href={'/del/bod/[id]'} as={`/del/bod/${encodeURIComponent(bod.team_meta)}`}>
                    <Image src={bod.team_image_url} alt="homepage bod" className='mb-3' height={180} width={500} />
                    <div className='m6'>
                        <p className='fs-6 fw-bold'>{bod.team_name}</p>
                        <p>{bod.team_desig}</p>
                    </div>
                </Link>
            </div>
        </>
    )
}

export default Boadofdirector;
