import React, { useEffect, useState } from 'react'
import Head from 'next/head'
import axios from 'axios';
import dynamic from 'next/dynamic';
import Layoutagri from '../_layoutagri';
import Members from './members';
const Agriheading = dynamic(() => import('../../components/Agri/Agriheading'));
const Agriintro = dynamic(() => import('../../components/Agri/Agriintro'));
const Visionintro = dynamic(() => import('../../components/Agri/vision'));
const Missionintro = dynamic(() => import('../../components/Agri/missionintro'));
const Desconresearch = dynamic(() => import('../../components/Agri/desconresearch'));
const Otherinitiatives = dynamic(() => import('../../components/Agri/others'));

const DOL = ({ htmlData, bod }) => {

  const [director, setDirector] = useState(bod);
  const [loading, setLoading] = useState(true);
  // const [showMore] = useState(false);

  useEffect(() => {
    if (bod?.length > 0) {
      setLoading(false)
      setDirector(bod)
    }
  }, [bod]);


  return (
    <>
      <Head>
        <title>Descon Agri-Business - About  | Descon</title>
        <meta name="description" content="Descon announced its foray into the agriculture sector in 2022 by setting Descon Agri Business (DAB)." key="desc" />
        <meta property="og:title" content="Descon Agri-Business - About " />
        <meta property="og:description" content="Descon announced its foray into the agriculture sector in 2022 by setting Descon Agri Business (DAB)." />
        <meta property="og:image" content="'/assets/dol/about/dol-bg.png" />
      </Head>
      <Layoutagri>
        <Agriheading />
        <Agriintro />
        <Visionintro />
        <Missionintro />
        <Desconresearch />
        <Otherinitiatives />
        {/* <Management Team /> */}
        <div className="bg-light agrimembers">
          <div className="container text-center">
            <div className='mb-5 col-md-8 mx-auto'>
              <h1>Management Team</h1>
              </div>
            <div className="row justify-content-center text-center bod">
              {
                loading ? (
                  <div className="text-center">
                    {/* <Image
                      src="/assets/loading-51.gif"
                      alt="Loading..."
                      width={80}
                      height={80}
                    /> */}
                  </div>
                ) : director && director.length > 0 ? (
                  director.map((bod, index) => {
                    return (
                      <Members
                        key={index}
                        bod={bod}
                      />
                    )
                  })
                ) : (
                  <div className="text-center" dangerouslySetInnerHTML={{ __html: htmlData }} />
                )
              }
            </div >
          </div >
        </div >
      </Layoutagri>
    </>
  )
}

const convertToHtml = (membersData) => {
  return membersData.map(members => `
        <div class="members-item">
          <h3>${members.team_name}</h3>
          <p>${members.team_desig}</p>
          <span>${members.timestamp}</span>
        </div>
        `).join('');
};

export const getStaticProps = async () => {
  try {
    const response1 = await axios.get("https://descon.com/en/rest-api/teams/read.php?verticals=dol&view_status=y&type_of_team=leader");
    let sortedTeam = response1.data.data.sort((a, b) => {
      const dateA = new Date(a.timestamp);
      const dateB = new Date(b.timestamp);
      return dateB - dateA;
    });

    const response2 = await axios.get("https://descon.com/en/rest-api/teams/read.php?verticals=agri&view_status=y&type_of_team=bod");
    let sortedbod = response2.data.data.sort((a, b) => {
      const dateA = new Date(a.timestamp);
      const dateB = new Date(b.timestamp);
      return dateB - dateA;
    });

    sortedTeam = sortedTeam.reverse();
    sortedbod = sortedbod.reverse();

    const htmlData1 = convertToHtml(sortedTeam);
    const htmlData2 = convertToHtml(sortedbod);

    return {
      props: {
        leaders: sortedTeam,
        bod: sortedbod,
        htmlData: htmlData1,
      }
    };
  } catch (error) {
    console.error("Error fetching members:", error);
    return {
      props: {
        leaders: [],
        bod: [],
        htmlData: '', // Return an empty array if there&apos;s an error
      }
    };
  }
};

export default DOL