import Link from 'next/link';
import Head from 'next/head';
import Layout from './_layout'

const Custom404 = () => {
    return (
        <>
            <Head>
                <title>404 ERROR | Descon</title>
                <meta name="description" content="ERROR" key="desc" />
                <meta property="og:title" content="ERROR" />
                <meta property="og:description" content="ERROR" />
                <meta property="og:image" content="https://www.descon.com/en/img/logo.png" />
            </Head>
            <Layout>
            <div style={{ textAlign: 'center', padding: '100px' }}>
                <h1>404 - Page Not Found</h1>
                <p>Sorry, the page you are looking for does not exist.</p>
                <Link href="/">
                    Go back to the homepage
                </Link>
            </div>
            </Layout>
        </>
    );
};

export default Custom404;
