import React from 'react'
import Image from 'next/image'

const Qhseintro = () => {
    return (
        <div className='container spacer' style={{ paddingTop: '2rem' }}>
            <div className='row'>
                <div className=' col-12'>                   
                  <h2>Sustainability Built for Our Sector, Aligned with Our Partners</h2>   
                   <p >  
                                    
At Descon, we see sustainability as a responsibility that grows with our scale. Over the past year, we’ve taken meaningful steps to build it into how we work, from strategy to site execution.<br/><br/>

As partners to leading energy and industrial players across the GCC, including ADNOC, Aramco, and QatarEnergy, we understand the responsibility that comes with scale. In FY 2024–25, we took meaningful steps to embed sustainability deeper into our operations and supply chain - not just to comply, but to contribute.<br/><br/>

We earned the Fast Mover badge in our EcoVadis sustainability assessment, reflecting tangible improvements in how we measure and manage ESG performance. Our first ESG report for Abu Dhabi operations was launched for internal stakeholders, with plans to extend reporting across other operating regions.<br/><br/>

We have also joined the United Nations Global Compact, reinforcing our alignment with global standards on ethics, transparency, and responsible business.<br/><br/>

Key initiatives include the transformation of our conventional supply chain into a sustainable value chain, and the rollout of measures to improve information security resilience. We are actively implementing systems for resource optimization, energy efficiency, and real-time utility monitoring across key sites.<br/><br/>

As a strategic partner to ADNOC, we initiated the Achilles self-assessment, supporting their responsible sourcing agenda with practical action.<br/><br/>

Our focus extends beyond systems to people. We continue to invest in building internal capability through targeted training, regional workshops, and case study sharing. Recognition through the Global Diversity, Equity and Inclusion Benchmark (GDIEB) in Training and Development affirms our commitment to inclusive, skills-first growth.<br/><br/>

Technology continues to support this momentum. With tools like ProAACT Phase II and SAP HANA now live, we are strengthening governance and operational agility across our projects.
For Descon, sustainability is not just about reporting progress. It is about building a future-ready business; one that evolves with our clients, supports national visions, and delivers impact where it matters most.
                   </p>
                  
                </div>                
                
                
            </div>
            <div className="row">
        <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/sust-1.png" alt="sust 1" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
        <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/sust-2.png" alt="sust 2" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
        
      </div>
      <style jsx>{`
        br {
         display:block !important
        }
      `}</style>
     
        </div>
    )
}

export default Qhseintro