
import React from 'react'
import Link from 'next/link'
import Image from 'next/image'


const Runningcontent = () => {
    return (
        <div className='container-fluid'>
            <div className='row mb-5'>
                <div className='col-12'>
                    <p className='biggerfont' >Framework</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                    <div className='img-fluid image4' >
                        <Image src='/assets/leadership1.jpg' alt='leadership' width={940} height={626} layout='responsive' className='img-fluid' />
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6   col-12 text-hse my-auto panel-right-adjust'>
                    <h1>Leadership Competency Framework</h1>
                    <p>Leadership is one of Descon&apos;s core values. Our leadership team provides guidance by teaching what they preach and leading by example through their diverse profiles and experiences. Descon has a developed framework in place that provides guidelines to every individual on the steps required in transforming their leadership.</p>

                    <div className='text-center'>
                        <Image src='/assets/leadership3.png' width={200} height={187}  alt='leadership3' className='img-fluid' />

                    </div>
                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12 '>

                    <p className='biggerfont text-end' >GTP</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                    <h1>Graduate Trainee Program</h1>
                    <p>
                        We believe that a diverse and inclusive workplace contributes to the development of all. FLIP GTP (Future Leadership Internship Program - Graduate Trainee Program) builds upon the knowledge-based foundation that the graduates have received.<br /><br />
                        The Trainee program is designed to nurture fresh graduates by providing them a platform which prepares them to be Descon&apos;s Future Leaders. The program comprises 2 parts; FLIP period of 2 months and GTP of 12 months tenure.<br /><br />
                        Descon&lsquo;s GTP aims to develop its future leaders through intensive projects, assignments, rotations, connects and assessments.
                    </p>
                    <Image src='/assets/gtp-flow.png' width={940} height={626} layout='responsive' alt='gtp' className='img-fluid' />
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image4 mb-4' >
                   <Link  target='_blank' href='https://www.youtube.com/watch?v=-I3AAJyhyqk'><Image src='/assets/gtp.jpg' width={940} height={626} layout='responsive' alt='gtp' className='img-fluid' /></Link>
                    </div>
                </div>

            </div>
            <div className='row mb-5'>
                <div className='col-12'>
                    <p className='biggerfont ' >Inspire</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                    <div className='img-fluid image4' >

                        <Image src='/assets/inspire1.jpg' alt='inspire' className='img-fluid' width={940} height={626} layout='responsive' />
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 text-hse my-auto panel-right-adjust'>
                    <h1>Inspire</h1>
                    <p>
                        INSPIRE, the first Female Apprenticeship Program has been launched with the primary intent to develop an inhouse talent nursery, specifically, a Female Talent Pool to serve the company&apos;s prospective needs. In this program, fresh graduates are imparted with Descon specific skillset which enables them to have a prosperous career ahead.<br /><br />
                        With the progressive & energizing nature of the program, this platform provides & enables the apprentices with a chance to explore their untapped potential in a conducive learning environment.
                    </p>

                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12'>
                    <p className='biggerfont text-end' >Vision</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                    <h1>Vision</h1>
                    <p>
                        In alignment with FLIP GTP (Future Leadership Internship Program - Graduate Trainee Program), VISION, an all female Graduate Trainee Program has been launched to become an employer of choice for female engineers by providing them with equal opportunities.<br /><br />
                        The Trainee program is designed to nurture fresh graduates by providing them with a platform that prepares them to become Descon&apos;s future leaders. The program is made up of 2 parts; FLIP period of 2 months and GTP of 12 months tenure.
                    </p>

                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image4' >
                        <Image src='/assets/vision1.jpg' alt='vision' className='img-fluid' width={940} height={626} layout='responsive' />
                    </div>
                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12'>
                    <p className='biggerfont' >ACCA</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                    <div className='img-fluid image4' >
                        <Image src='/assets/acca.jpg' alt='acca' className='img-fluid' width={940} height={626} layout='responsive' />
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6   col-12 text-hse my-auto panel-right-adjust'>
                    <h1>ACCA Trainee Program</h1>
                    <p>As part of developing Future Leaders and Functional Experts, ACCA Trainee Program has been launched to develop a talent pipeline in Finance, with periodic rotations and numerous assignments.</p>
                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12'>
                    <p className='biggerfont text-end' >Digitization</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                    <h1>Digitization for Operational Excellence</h1>
                    <p>
                        Descon Engineering is committed to achieving Operational Excellence by embracing digitization across its business processes. Through Project Beyond, we are revolutionizing work-life integration with the introduction of Decibel. Aligned with our core value of continuous improvement, Project Beyond is built on 35 principles that provide a user-friendly digital platform for seamless learning and easy access to information.<br /><br />
                        To enhance operational efficiency, we have launched ProAACT, a customized SAS-based software. ProAACT empowers us to efficiently execute company operations by capturing and analyzing real-time data. This comprehensive tool covers areas such as ERM, HSE, Lessons Learned, Cost of Poor Quality, Bid stage go/no-go decisions, and Actions Management. By leveraging data-driven insights, we are embarking on a transformative journey of ‘Transforming data into Business Acumen’ to turn data into valuable business intelligence.

                    </p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image4' >
                        <Image src='/assets/digitization.jpg' alt='digitize' className='img-fluid' width={940} height={626} layout='responsive' />
                    </div>
                </div>
            </div>
        </div>
    )
}
export default Runningcontent
