import React from 'react'
import Image from 'next/image'
import Link from 'next/link'


const Videos = () => {
    return (
        <div className='mt-5 pb-5'>
            <div className="container d-none">
                <div className="row">
                    <div className="col-4">
                        <input type="text" placeholder="Search.." />
                    </div>
                </div>
            </div>
            <div className='mt-5'>
                <h5>Descon Video Library</h5>
                <p>Watch and learn from Descon&apos;s insightful videos. Our video section
                    features informative content about our services, products, and innovations,
                    giving you a glimpse into our organisation&apos;s culture.</p>
            </div>
            <div className="container-fluid">
                <div className="row row-cols-1 row-cols-md-3 g-3" >
                    <div className="col-sm">
                        <div className='cards h-100'>
                        <Link target='_blank' href='https://www.youtube.com/watch?v=-I3AAJyhyqk&t=13s'>
                            <Image src='/assets/video1.webp'  width={416} height={227} className="card-img-top" alt="..."  />
                            </Link>
                            <div className="card-body">
                                <ul className="d-flex list-unstyled mt-auto">
                                    <li className="me-auto">
                                        <Image src='/assets/image30.png' alt="Bootstrap" width="32" height="32" className="rounded-circle border border-white" />
                                        <small> via Youtube</small>
                                    </li>
                                    <li className="d-flex align-items-center me-3">
                                        <svg className="bi me-2" width="1em" height="1em"><use href="#geo-fill"></use></svg>
                                    </li>
                                    <li className="d-flex align-items-center">
                                        <svg className="bi me-2" width="1em" height="1em"><use href="#calendar3"></use></svg>
                                        <small>7:42</small>
                                    </li>
                                </ul>
                                <h5 className="card-title mt-2"> Descon Graduate Trainee Program</h5>
                               
                            </div>
                        </div>
                    </div>
                    <div className="col-sm">
                        <div className='cards h-100'>
                            <Link target='_blank' href='https://www.youtube.com/watch?v=RNOU8MiQtIc'>
                            <Image src='/assets/video2.webp'  width={416} height={227} className="card-img-top" alt="..."  />
                            </Link>
                            
                            <div className="card-body">
                                <ul className="d-flex list-unstyled mt-auto">
                                    <li className="me-auto">
                                        <Image src='/assets/image30.png' alt="Bootstrap" width="32" height="32" className="rounded-circle border border-white" />
                                        <small> via Youtube</small>
                                    </li>
                                    <li className="d-flex align-items-center me-3">
                                        <svg className="bi me-2" width="1em" height="1em"><use href="#geo-fill"></use></svg>
                                    </li>
                                    <li className="d-flex align-items-center">
                                        <svg className="bi me-2" width="1em" height="1em"><use href="#calendar3"></use></svg>
                                        <small>1:01</small>
                                    </li>
                                </ul>
                                <h5 className="card-title mt-2">DTI Success Stories</h5>
                               
                            </div>
                        </div>
                    </div>
                    <div className="col-sm">
                        <div className='cards h-100'>
                        <Link target='_blank' href='https://www.youtube.com/watch?v=21FOnsVeLJs&t=156s'>
                            <Image src='/assets/video3.webp'  width={416} height={227} className="card-img-top" alt="..."  />
                            </Link>
                            <div className="card-body">
                                <ul className="d-flex list-unstyled mt-auto">
                                    <li className="me-auto">
                                        <Image src='/assets/image30.png' alt="Bootstrap" width="32" height="32" className="rounded-circle border border-white" />
                                        <small> via Youtube</small>
                                    </li>
                                    <li className="d-flex align-items-center me-3">
                                        <svg className="bi me-2" width="1em" height="1em"><use href="#geo-fill"></use></svg>
                                    </li>
                                    <li className="d-flex align-items-center">
                                        <svg className="bi me-2" width="1em" height="1em"><use href="#calendar3"></use></svg>
                                        <small>4:45</small>
                                    </li>
                                </ul>
                                <h5 className="card-title mt-2">Descon Technical Institute | Corporate Story</h5>
                                
                            </div>
                        </div>
                    </div>
                </div >
            </div>
        </div >
    )
}

export default Videos
