import React, { useEffect, useState } from 'react'
import Link from 'next/link';
import Image from 'next/image';
import Newslettercard from './newslattercard';
import axios from 'axios';

const Newsletter = () => {
    const [letter, setLetter] = useState([]);

    useEffect(() => {
        axios.get("https://descon.com/en/rest-api/newsletter/read.php")
            .then((response) => {
                const sortedNews = response.data.data.sort((a, b) => {
                    const dateA = new Date(a.newsletter_date);
                    const dateB = new Date(b.newsletter_date);
                    return dateB - dateA;
                  });
                  setLetter(sortedNews);
                // setLetter(response.data.data);
            }).catch((err) => {
                console.log(err, "Error")
            });
    }, [])


    return (
        <div className='mt-5 pb-5'>
            <div className="container d-none">
                <div className="row">
                    <div className="col-4">
                        <input type="text" placeholder="Search.." />
                    </div>
                </div>
            </div>
            <div className='mt-5'>
                <h5>Newsletter</h5>
                <p>Our newsletter is your source for the latest news and insights
                    on Descon. Enjoy reading the quarter-wise happenings at the Descon companies.</p>
            </div>
            <div className="container-fluid">
                <div className="row row-cols-1 row-cols-md-3 g-3" >
                    {letter && letter.length > 0 ? (

                        letter.map((letter, index) => {
                            return (
                                <>
                                    <Newslettercard key={index} letter={letter} />
                                </>
                            )
                        })
                    ) : (
                        <div className="text-center">
                            <Image src="/loading-51.gif" alt="Loading..." width={80} height={80} style={{
                                marginRight: "-50rem"
                            }} />
                        </div>
                    )
                    }
                </div >
            </div>
        </div >
    )
}

export default Newsletter

