import React from 'react'
import Link from 'next/link';

const NewsCard = ({ news }) => {

  const formattedDate = news.news_date ? new Date(news.news_date).toLocaleString('en-US', {
    month: 'long',
    day: 'numeric',
    year: 'numeric',
  }) : '';

  return (
    <div className="col-12 col-lg-4" >
      <div className='cards h-100' role="button">
        <div
          className="card card-cover overflow-hidden text-white position-relative" // Add position-relative class
          style={{
            height: "250px",
            backgroundImage: `linear-gradient(190deg, rgba(0, 0, 0, 0) 0%, rgba(0, 0, 0, 0.364) 68.75%), url(${news.media_url})`,
            backgroundSize: 'cover',
            backgroundRepeat: 'no-repeat',
          }}
        >
          <div className="d-flex flex-column h-100 p-5">
            <h4 className="mt-5  lh-1 fw-bold text-white fs-6">{news.news_title}</h4>
            <h4 className="mt-1 lh-1 text-white fs-6">{formattedDate}</h4>
            <ul className="d-flex list-unstyled mt-auto">
              <li className="me-auto">
                <Link href={'/news/[id]'} as={`/news/${encodeURIComponent(news.news_meta)}`} className='btn btn-sm btn-outline-light'>Read more</Link>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  );
};



export default NewsCard;
