import React, { useState } from 'react';
import { Tab, Nav } from 'react-bootstrap';
import Newsevents from './newsevents';
import Newsletter from './newsletter';
import Videos from './videos';

function Mediatap() {
    const [activeTab, setActiveTab] = useState('tab1');

    const handleTabSelect = (eventKey) => {
        setActiveTab(eventKey);
    };

    return (
        <div className='container'>
            <div className='row'>
                <div className='col-lg-12 col-12 mx-auto mt-5'>
                    <Tab.Container activeKey={activeTab} onSelect={handleTabSelect}>
                        <Nav variant="tabs" className='mediatabs'>
                            <Nav.Item>
                                <Nav.Link eventKey="tab1">News & Events</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link eventKey="tab2">Newsletter</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link eventKey="tab3">Videos</Nav.Link>
                            </Nav.Item>
                        </Nav>
                        <Tab.Content>
                            <Tab.Pane eventKey="tab1">
                                <Newsevents/>
                            </Tab.Pane>
                            <Tab.Pane eventKey="tab2">
                            <Newsletter/>
                            </Tab.Pane>
                            <Tab.Pane eventKey="tab3">
                            <Videos/>
                            </Tab.Pane>
                        </Tab.Content>
                    </Tab.Container>
                </div>
            </div>
        </div>
    );
}

export default Mediatap;