import Image from 'next/image'
import React from 'react'


const OandMintro = () => {
    return (
        <div className='container-fluid'>
            <div className='row mb-5'>
                <div className='col-12'>
                    <p className='biggerfont' >O&M</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                    <div className='img-fluid image4' >
                        <Image src='/assets/dps/services/o&m-banner.jpg' alt='Strategy' width={940} height={560} className='img-fluid' />
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6   col-12 text-hse my-auto panel-right-adjust'>
                    <h1>Operations & Maintenance</h1>
                    <p>Operation and Maintenance (O&M) outsourcing allows plant owners to cost-effectively optimize their O&M strategy and share risks and responsibilities with a reliable and experienced partner. DPS assures plant performance parameters by robustly executing O&M plans that significantly reduce the risk of unscheduled outages.</p>
                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12 '>
                    <p className='biggerfont text-end' >Crane Services</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                    <h1>Crane Services for Wind Power Plants</h1>
                    <p>
                        Descon offers a diverse range of cranes, including our standout 750-ton crane, dedicated to serving our customers in the Wind Power Plants sector for maintenance purposes. Whether it involves replacing an entire gearbox, exchanging main bearings, or executing a full rotor drop, DPS fully assists owners, OEMs, and others in providing the requisite crane services to their complete satisfaction. We own a fleet of cranes with a diverse range of capabilities, which enables us to perform critical jobs such as blade-by-blade removal of wind turbine&apos;s rotor and major component exchange.
                    </p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image4' >
                        <Image src='/assets/dps/services/crane-banner.png' width={940} height={560} alt='committment' className='img-fluid' />
                    </div>
                </div>

            </div>
            <div className='row mb-5'>
                <div className='col-12'>
                    <p className='biggerfont' >Field Support</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                    <div className='img-fluid image4' >
                        <Image src='/assets/dps/services/field-banner.png' width={940} height={560} alt='adopting' className='img-fluid' />
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 text-hse my-auto panel-right-adjust'>
                    <h1>Field Service Support<p>Thermal and Wind Power Plants</p></h1>
                    <p>
                        In case of gas and turbines, we offer field services support for all types of outages (Combustion Inspection, Hot Gas Path Inspection and Major Inspection). DPS possess a large database which allows us to find technical resources in the shortest possible time.
                    </p>
                    <p>
                    Descon Power Solutions (DPS) is capable to provide various field services to its wind energy customers. These include wind turbine blade inspection and repair, various gearbox services including borescope inspection and other related services to the complete satisfaction of the owners / OEMs.
                    </p>
                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12 '>
                    <p className='biggerfont text-end' >Warranty Inspection</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                    <h1>End of Warranty Inspections</h1>
                    <p>
                    Descon Power Solutions (DPS) offers &apos;End of Warranty Inspection&apos; services to wind power plants in Pakistan in partnership with local and foreign service providers. The services include inspections of WTG, EBOP, Civil and HSE, and can be tailored to meet the specific needs of customers.
                    </p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image4' >
                        <Image src='/assets/dps/services/warranty-banner.png' width={940} height={560} alt='committment' className='img-fluid' />
                    </div>
                </div>

            </div>


        </div>
    )
}

export default OandMintro