import Image from 'next/image'
import Link from 'next/link'
import React from 'react'


const Strategyintro = () => {
    return (
        <div className='container-fluid'>
                <div className='row mb-5'>
                    <div className='col-12 '>
                        <p className='biggerfont text-end' >Vision</p>
                    </div>
                    <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                        <h1>HSE Vision</h1>
                        <p>
                            Descon Power Solutions (DPS) has strategically decided to adopt an Integrated Management System (IMS) to improve its overall performance, provide a sound basis for sustainable growth initiatives, and facilitate opportunities to enhance customer satisfaction.
                        </p>
                    </div>
                    <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                        <div className='img-fluid image4' style={{ zIndex: "2" }}>
                            <Image src='/assets/dps/qhse/vision-img.png' width={940} height={560} layout='responsive' alt='committment' className='img-fluid' />
                        </div>
                    </div>

                </div>
            <div className='row mb-5'>
                <div className='col-12'>
                    <p className='biggerfont' >Strategy</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                    <div className='img-fluid image4' style={{ zIndex: "2" }}>
                        <Image src='/assets/dps/qhse/strategy-img.png' alt='Strategy' width={940} height={560} layout='responsive' className='img-fluid' />
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6   col-12 text-hse my-auto panel-right-adjust'>
                    <h1>HSE Strategy</h1>
                    <p>Our HSE strategy is designed to keep us focused on tackling both new and traditional risks at the right time and in the right way. By setting clear objectives and themes, we can guide our future interventions and regulatory activities.</p>
                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12 '>
                    <p className='biggerfont text-end' >Commitment</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                    <h1>HSE Commitment</h1>
                    <p>
                        Our Health and Safety commitment is to ensure that our employees, contractors, and visitors are safe and healthy while working on our sites. We will achieve this by providing safe work practices and ensuring that all employees are trained in health and safety best practices. HSE is a core value of our company, and every employee religiously follows its rules under the guidance of the Head of QEHS.
                    </p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image4' style={{ zIndex: "2" }}>
                        <Image src='/assets/dps/qhse/commitment-img.png' width={940} height={560} layout='responsive' alt='committment' className='img-fluid' />
                    </div>
                </div>

            </div>
            <div className='row mb-5'>
                <div className='col-12'>
                    <p className='biggerfont' >New Ways</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                    <div className='img-fluid image4' style={{ zIndex: "2" }}>
                        <Image src='/assets/dps/qhse/adopting-img.png' width={940} height={560} layout='responsive' alt='adopting' className='img-fluid' />
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 text-hse my-auto panel-right-adjust'>
                    <h1>Adopting New Ways of Working</h1>
                    <p>
                        Descon Power Solutions is continuously exploring new ways to enhance employee engagement in strengthening its HSE commitment and making DPS accident-free. The annual safety award is distributed among all sites. During the annual safety week, different employee engagement activities are planned, such as a safety poster drawing competition, incident investigation tasks, and safety quizzes. Safety champions are awarded gifts and prizes.
                    </p>
                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12 '>
                    <p className='biggerfont text-end' >Certificate</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                    <div className='row'>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dps/qhse/pec-license-2021.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>PEC License</p>
                                    <p className=' text-danger'>File Size: 2.1 MB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dps/qhse/iso-certificates.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>ISO Certificates</p>
                                    <p className=' text-danger'>File Size: 1.2 MB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dps/qhse/iso-9001-QMS.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>Descon Power Solutions - QMS Certificate 9001</p>
                                    <p className=' text-danger'>File Size: 1.8 MB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dps/qhse/iso-45001-OHSMS.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>Descon Power Solutions - OHSMS Certificate 45001</p>
                                    <p className=' text-danger'>File Size: 1.8 MB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dps/qhse/iso-14001-EMS.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>Descon Power Solutions - EMS Certificate 14001</p>
                                    <p className=' text-danger'>File Size: 1.8 MB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dps/qhse/dps-pec-certificate.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>Descon Power Solutions - PEC Certificate</p>
                                    <p className=' text-danger'>File Size: 0.6 MB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dps/qhse/dps_qehs_policy_rev_3.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>Descon Power Solutions - QEHS Policy</p>
                                    <p className=' text-danger'>File Size: 0.2 MB</p>
                                </Link>
                            </div>
                        </div>
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image4' style={{ zIndex: "2" }}>
                        <Image src='/assets/dps/qhse/certificate-img.png' alt='certificate' className='img-fluid' width={151} height={151} layout='responsive' />
                    </div>
                </div>

            </div>


        </div>
    )
}

export default Strategyintro