import React, { useEffect, useState } from 'react'
import Link from 'next/link';
import Image from 'next/image';



const Investorrelations = () => {
  return (
    <>
      <div className='col-lg-10 col-12 mx-auto pt-5'>
        <div className='mt-5'>
          <div className='mt-5'>
            <div className='container-fluid media'>

              {/* ================SECP`s Investor Complaint Section======== */}

              <div className="row">
                <h5 className='fw-bold'>SECP`s Investor Complaint Section</h5>
                <div className="col-lg-8 col-12 mb-5">
                  <Image src='/assets/dol/company-info/investor/secp-investor.png' alt="homepage news" className=' img-fluid mt-4' width={1000} height={227} />
                  <p className='mt-3 text-secondary'>
                    Disclaimer: “In case your complaint has not been properly redressed by us, you may lodge your complaint with Securities and Exchange Commission of Pakistan (the “SECP”). However, please note that SECP will entertain only those complaints which were at first directly requested to be redressed by the company and the company has failed to redress the same. Further, the complain that are not relevant to SECP’ regulatory domain/competence shall not be entertained by the SECP”.
                  </p>
                  <h6
                    className='fw-bold fs-6 text-decoration-none text-dark'>
                    <div>
                      Symbol Of The Company Assigned By Respective Stock Exchange
                    </div>
                  </h6>
                  <p className=" card-text">DOL <Link className="text-decoration-none" href='https://www.psx.com.pk/index.php' target='_blank'>https://www.psx.com.pk/index.php</Link></p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className='dolmainheading' style={{
        backgroundImage: `url('/assets/dol/company-info/profilegovernance/chemical.png')`,
        backgroundSize: 'cover',
        backgroundRepeat: 'no-repeat',
      }}>
      </div>
      {/* ================Free Float of the shares ======= */}
      <div className='col-lg-10 col-12 mx-auto pt-5'>
        <div className="container">
          <div className="row rtl">
            <div className="col-lg-3 col-12 mb-5">
              <h5 className='fw-bold fs-4'>شیئرز کا فری فلوٹ</h5>
              <p className='pt-4 auditor' style={{fontSize:"17px", lineHeight:"1.3"}}>ڈیسکون آکسیکیم لمیٹڈ:<span className="fw-bold">37,356,737</span></p>
            </div>
            <div className="col-lg-3 col-12 mb-5">
              <h5 className='fw-bold fs-4'>کمپنی ریٹنگز</h5>
              <p className='pt-4 auditor' style={{fontSize:"17px", lineHeight:"1.3"}}>طویل المدت: <span className="fw-bold">A</span></p>
              <p className='auditor' style={{fontSize:"17px", lineHeight:"1.3"}}>قلیل المدت: <span className="fw-bold">A1</span></p>
            </div>
            <div className="col-lg-3 col-12 mb-5">
              <h5 className='fw-bold fs-4'>سرمایہ کاروں کےلئے کمپنی کی رابطے کی تفصیلات</h5>
              <p className='pt-4' style={{fontSize:"17px", lineHeight:"1.3"}}>جناب عبد السہیل </p>
              <p >کمپنی سیکریٹری</p>
              <Link className="text-decoration-none" href='#mailto:Abdul.Sohail@descon.com'>Abdul.Sohail@descon.com</Link>
            </div>
            <div className="col-lg-3 col-12 mb-5">
              <h5 className='fw-bold fs-4'>شیئر رجسٹرار </h5>
              <h6 className='fw-bold text-dark pt-4 fs-5'><div>میسرز کارپ لنک ( پرائیویٹ) لمیٹڈ</div></h6>           <p style={{fontSize:"17px", lineHeight:"1.3"}}>ونگز آرکیڈ ، 1-kکمرشل ایریا ، ماڈل ٹاؤن ، لاہور ،53000</p>
              <p className='auditor'>Tel: <Link className="text-decoration-none fw-bold text-dark" href='tel:+92 42 35887262'>+92 42 35887262, 35839182</Link></p>
            </div>
          </div>
        </div>
      </div>
    </>
  )
}

export default Investorrelations