import Image from 'next/image'
import Link from 'next/link'
import React from 'react'

const Companydetails = () => {
    return (
        <>
            <div style={{ backgroundColor: "#F2F2F2" }}>
                <div className='col-lg-10 col-12 mx-auto pt-5'>
                    <div className='container'>
                        <div className="row mt-5">
                            <div className="col-lg-3 col-12 mb-5">
                                <h5 className='fw-bold'>Company Contact Details</h5>
                                <h6 className='fw-bold text-dark pt-4'><div>Descon Headquarters</div></h6>
                                <p >Tel:<Link className="text-decoration-none fw-bold text-dark" href='tel:+924235990034'> +92 42 35990034</Link></p>
                                <p >Fax:<Link className="text-decoration-none fw-bold text-dark" href='tel:+924235401938'> +92 42 35401938</Link></p>
                                <p>18-KM Ferozpur Road Lahore 53000 Pakistan</p>
                                <Link className="text-decoration-none" href='#mailto:DOL@descon.com'>DOL@descon.com</Link>
                            </div>
                            <div className="col-lg-3 col-12 mb-5">
                                <h5 className='fw-bold'>Registration Information</h5>
                                <p className='pt-4 auditor'>Registration no.<span className="fw-bold">0048852</span></p>
                                <p className='auditor'>Registration Date.<span className="fw-bold">November 12, 2004</span></p>
                                <p className='auditor'>National Tax no.<span className="fw-bold">2276192-6</span></p>
                                <p className='auditor'>Sale Tax Reg. No.<span className="fw-bold">03-04-2847-002-28</span></p>
                            </div>
                            <div className="col-lg-3 col-12 mb-5">
                                <h5 className='fw-bold'>Plant Site</h5>
                                <p className='pt-4'>18-KM Lahore - Sheikhupura Road, Lahore, Pakistan</p>
                                <p >Tel:<Link className="text-decoration-none fw-bold text-dark" href='tel:+924237971821-24'>+92 42 3797 1821-24</Link></p>
                                <p >Fax:<Link className="text-decoration-none fw-bold text-dark" href='fax:+924237971831'>+92 42 3797 1831</Link></p>
                            </div>
                            <div className="col-lg-3 col-12 mb-5">
                                <h5 className='fw-bold'>Company Status</h5>
                                <h6 className='fw-bold text-dark pt-4'><div>Public Limited Company</div></h6>
                            </div>
                        </div>
                    </div>
                </div>
                <div className='dolmainheading' style={{
                    backgroundImage: `url('/assets/dol/company-info/profilegovernance/chemical.png')`,
                    backgroundSize: 'cover',
                    backgroundRepeat: 'no-repeat',
                }}>
                </div>
                <div className='col-lg-10 col-12 mx-auto pt-5'>
                    <div className='container'>
                        <div className="row mt-5">
                            <div className="col-lg-3 col-12 mb-5">
                                <h5 className='fw-bold'>Bankers</h5>
                                <h6 className='fw-bold text-dark pt-4'><div>Allied Bank</div></h6>
                                <h6 className='fw-bold text-dark pt-4'><div>Bank Al Habib</div></h6>
                                <h6 className='fw-bold text-dark pt-4'><div>Habib Metropoliton Bank</div></h6>
                            </div>
                            <div className="col-lg-3 col-12 mb-5">
                                <h5 className='fw-bold'>Auditors</h5>
                                <h6 className='fw-bold text-dark pt-4'><div>Crowe Hussain Chaudhury & Co.</div></h6>
                                <p className='pt-4'>Chartered Accountants</p>
                            </div>
                            <div className="col-lg-3 col-12 mb-5">
                                <h5 className='fw-bold'>Internal Auditors</h5>
                                <h6 className='fw-bold text-dark pt-4'><div>M/s KPMG Taseer Hadi & Co.</div></h6>
                                <p className='pt-4'>Chartered Accountants</p>
                            </div>
                            <div className="col-lg-3 col-12 mb-5">
                                <h5 className='fw-bold'>Legal Advisor</h5>
                                <h6 className='fw-bold text-dark pt-4'><div>M/s Hassan & Hassan Advocates</div></h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </>

    )
}

export default Companydetails