import Image from 'next/image';
import React from 'react'
import Carousel from 'react-multi-carousel';
import 'react-multi-carousel/lib/styles.css';


const DolOwelcarousel = () => {
    const responsive = {
        superLargeDesktop: {
            // the naming can be any, depends on you.
            breakpoint: { max: 4000, min: 3000 },
            items: 3
        },
        desktop: {
            breakpoint: { max: 3000, min: 991 },
            items: 3
        },
        tablet: {
            breakpoint: { max: 991, min: 464 },
            items: 2
        },
        mobile: {
            breakpoint: { max: 991, min:0 },
            items: 1
        }
    };
    return (
        <>
            <div className='carousel doltestimonial-content'>
                <Carousel
                className='py-4 carousel-with-dots'
                    showDots={true}
                    responsive={responsive}
                    infinite={true}
                    arrows={false} renderButtonGroupOutside={true}
                >
                   
                   <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/dol/career/doltestimonial/muntaha-khan.png' width={361} height={202} layout='responsive' className="img-fluid card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>Descon offers more than work; it&apos;s a supportive family valuing growth, well-being, and genuine care.</p>
                            <div className="card-footer">
                                <h5 className="card-title text-dark">Muntaha Khan</h5>
                                <small className="text-dark">Human Resource <span>Descon Oxychem</span></small>
                            </div>
                        </div>
                    </div>
                    <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/dol/career/doltestimonial/mujahid-ali.png' width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>Descon: an exceptional workplace blending innovation, inclusivity, fostering growth, positive culture, and impactful community contributions.</p>
                            <div className="card-footer ">
                                <h5 className="card-title text-dark">Mujahid Ali</h5>
                                <small className="text-dark font-weight-bold">Maintenance<span>Descon Oxychem</span></small>
                            </div>
                        </div>
                    </div>
                  
                    <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/dol/career/doltestimonial/zainab-dawood.png' width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>Descon&apos;s commitment to diversity and empowering women inspired me; proud to contribute to their vision.</p>
                            <div className="card-footer">
                                <h5 className="card-title text-dark">Zainab Dawood</h5>
                                <small className="text-dark">Supply Chain <span>Descon Oxychem</span></small>
                            </div>
                        </div>
                    </div>
                   
                   
                  
                </Carousel>
            </div>
        </>
    )
}

export default DolOwelcarousel
