import React, { useState } from 'react';

const COCform = () => {
  const [formData, setFormData] = useState({
    full_name: '',
    company_name: '',
    email_address: '',
    phone_num: '',
    concern: '',
    vertical: 'DOL',
    ip: '',
    attachment: null,
  });

  const [successMessage, setSuccessMessage] = useState('');
  const [errorMessage, setErrorMessage] = useState('');

  const handleChange = (event) => {
    const { name, value } = event.target;
    setFormData({
      ...formData,
      [name]: value,
    });
  };

  const handleImageChange = (event) => {
    const file = event.target.files[0];
    if (file.size <= 20 * 1024 * 1024) {
      setFormData({
        ...formData,
        attachment: file,
      });
    } else {
      // Display an error message or handle the large image in some way.
      console.error('Image size exceeds 20MB limit');
    }
  };

  const handleSubmit = async () => {
    // Validate the form fields before submission
    if (
      !formData.full_name ||
      !formData.company_name ||
      !formData.email_address ||
      !formData.phone_num ||
      !formData.concern
    ) {
      setErrorMessage('Please fill all required fields.');
      return;
    }

    // Convert form data to FormData object
    const data = new FormData();
    for (const key in formData) {
      if (key !== 'attachment' || (key === 'attachment' && formData[key])) {
        data.append(key, formData[key]);
      }
    }

    // API endpoint URL
    const apiUrl = 'https://www.descon.com/en/rest-api/coc/create.php';

    try {
      // Send form data using fetch API
      const response = await fetch(apiUrl, {
        method: 'POST',
        body: data,
      });

      if (response.ok) {
        // Form submitted successfully
        console.log('Form submitted successfully');
        setSuccessMessage(
          'Form submitted successfully! Our team will revert upon receiving.'
        );
        setErrorMessage('');
        // Reset the form after successful submission
        setFormData({
          full_name: '',
          company_name: '',
          email_address: '',
          phone_num: '',
          concern: '',
          vertical: 'DOL',
          ip: '',
          attachment: null,
        });
      } else {
        // Handle form submission error
        console.error('Form submission failed');
      }
    } catch (error) {
      // Handle other errors, e.g., network issues
      console.error('Error occurred:', error);
    }
  };

  return (
    <div className='contact'>
      <div className='container'>
        <div className='row rtl'>
          <div className='col-lg-6 col-12 col-md-12 mt-4 mb-5 WBFORM'>
            <h1 className='fw-bold text-dark'>اپنی شکایت درج  کروائیں</h1>
            <p className='text-muted mt-3' style={{
              lineHeight: "1.3",
              fontSize: "17px",
            }}>براہ ِ مہربانی اس بات کو  یقینی بنائیں کہ آپ اپنے پیغام میں درج ذیل تفصیلات کا شیئر کریں۔</p>
            <div className='row mt-5'>
              <div className='col-12 mb-4' >
                <label htmlFor='full_name' className='form-label' required style={{
                  lineHeight: "1.3",
                  fontSize: "17px",
                }}>
                  پورا نام
                </label>
                {/* <input
                  type='text'
                  className='form-control form-control-lg'
                  name='full_name'
                  value={formData.full_name}
                  onChange={handleChange}
                /> */}
              </div>
              <div className='col-12 mb-4'>
                <label htmlFor='company_name' className='form-label' required style={{
                  lineHeight: "1.3",
                  fontSize: "17px",
                }}>
                  کمپنی/وینڈر کا نام
                </label>

                {/* <input
                  type='text'
                  className='form-control form-control-lg'
                  name='company_name'
                  value={formData.company_name}
                  onChange={handleChange}
                /> */}
              </div>
              <div className='col-12 mb-4'>
                <label htmlFor='phone_num' className='form-label' required style={{
                  lineHeight: "1.3",
                  fontSize: "17px",
                }}>
                  فون نمبر
                </label>
                {/* <input
                  type='text'
                  className='form-control form-control-lg'
                  name='phone_num'
                  value={formData.phone_num}
                  onChange={handleChange}
                /> */}
              </div>
              <div className='col-12 mb-4'>
                <label htmlFor='email_address' className='form-label' required style={{
                  lineHeight: "1.3",
                  fontSize: "17px",
                }}>
                  ای میل ایڈریس
                </label>
                {/* <input
                  type='email'
                  className='form-control form-control-lg'
                  name='email_address'
                  value={formData.email_address}
                  onChange={handleChange}
                /> */}
              </div>
              <input type="hidden"
                name="division"
                value={formData.vertical}
                onChange={handleChange}
              />
              <div className='col-12 mb-4'>
                <label htmlFor='concern' className='form-label' required style={{
                  lineHeight: "1.3",
                  fontSize: "17px",
                }}>
                  معاملہ
                </label>
                {/* <textarea rows="6"
                  className='form-control form-control-lg'
                  placeholder='Write your concern here'
                  name='concern'
                  value={formData.concern}
                  onChange={handleChange}
                ></textarea> */}
              </div>
              <div className='col-12 mb-4'>
                <label htmlFor='formFile' className='form-label' style={{
                  lineHeight: "1.3",
                  fontSize: "17px",
                }}>
                  ثبوت
                </label>
                {/* <input className='form-control' type='file' id='formFile' name='attachment' onChange={handleImageChange} /> */}
              </div>
              <div className='d-grid gap-2'>
                {/* <button className='btn btn-primary' type='button' onClick={handleSubmit}>
                  Send Message
                </button> */}
                <a className='btn btn-primary' type='button' href='mailto:blowthewhistle@descon.com?subject=Whistleblowing%20-%20DOL&body=Name%20%3A%20%0ACompany%2FVendor%20Name%20%3A%20%0APhone%20Number%20%3A%20%0AEmail%20address%20%3A%20%0AConcern%20%3A%20%0AEvidence%20%3A'>
                  Compose Message
                </a>
              </div>
              {errorMessage && <div className='alert alert-danger mt-4'>{errorMessage}</div>}
              {successMessage && <div className='alert alert-success mt-4'>{successMessage}</div>}
            </div>
          </div>
          <div className='col-lg-5 col-12 col-md-12 mt-4  mb-5  WB'>
            <h1 className='fw-bold text-dark'>تعریفیں</h1>

            <h3>رشوت</h3>
            <p style={{
              lineHeight: "1.3",
              fontSize: "17px",
            }}>
              رشوت سے مراد کسی  بھی  رقم کی ادائیگی یا کوئی بھی احسان  جو ادارے  میں کسی بھی اتھارٹی کے فرد  کے فیصلے یا طرز عمل پر اثر انداز ہونے کے لیے دی گئی یا وعدہ کی گئی ہو۔  رشوت تحائف، سفری اخراجات، مارکیٹ سے کم  قرضا جات کی سہولت ، احسانات اور کاروبار/روزگار کے مواقع وغیرہ کی صورت میں بھی ہوسکتی ہے۔
            </p>

            <h3>ممنوعہ/سہولت کی ادائیگی</h3>
            <p style={{
              lineHeight: "1.3",
              fontSize: "17px",
            }}>وصول کنندہ کے فیصلے پر اثر انداز ہونے کے لیے، ناجائز  فوائد کی پیشکش کرنا یا دینا یا ادائیگی کرناہے ۔</p>

            <h3>مفادات کا تنا زعہ</h3>
            <p style={{
              lineHeight: "1.3",
              fontSize: "17px",
            }}>
              مفادات کا تنازعہ  اس وقت ہو سکتا ہے جب کوئی ملازم یا اس کے خاندان کا کوئی فرد کسی ایسی سرگرمی میں ملوث ہو یا اس کا ذاتی مفاد ہو جو متعلقہ مقصد  اور منصفانہ فیصلے کرنے کی صلاحیت کو خراب کرے ، یا اس سے بھی محروم کر دے یا کوئی دیگر ترغیب پیدا کر ے اور  اس انداز  سے کام کرے  کہ  ڈیسکون کو سہارا بناکر    ذاتی مفادات حاصل کرے۔
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default COCform;

