import React from 'react'
import Link from 'next/link';
import Image from 'next/image';

const Leadership = () => {
    return (
        <div className='bg-leadership p-5 position-relative'>
            <div className='mb-5 col-md-10 mx-auto'>
                <h1>Leadership Team</h1>
                <p className='text-white'>Descon Engineering’s leadership team comprises competent and experienced individuals. They are responsible for conceptualizing and articulating goals that bring our people together in pursuit of set objectives. They lead the company with firm commitment to the values and vision of Descon Engineering.</p>
            </div>
            <div className="box-leadership">
                <div className="container">
                    <div className="row align-items-center text-center bod position-relative" >
                        <div className="col-lg-3 col mb-5">
                            <Link className='text-decoration-none' href='/del/leadership/taimur-saeed'>
                                <Image src='/assets/team/0.png' alt='Taimur Saeed' className='mb-3' height={180} width={500} />
                                <div className='m6'>
                                    <p className='fs-6 fw-bold'>Taimur Saeed</p>
                                    <p>Chief Executive Officer</p>
                                </div>
                            </Link>
                        </div>
                        <div className="col-lg-3 col mb-5">
                            <Link className='text-decoration-none' href='/del/leadership/adnan-bakhtiar'>
                                <Image src='/assets/team/6.png' alt='Adnan Bakhtiar' className='mb-3' height={180} width={500} />
                                <div className='m6'>
                                    <p className='fs-6 fw-bold'>Adnan Bakhtiar</p>
                                    <p>President - Infrastructure Division</p>
                                </div>
                            </Link>
                        </div>
                        <div className="col-lg-3 col mb-5">
                            <Link className='text-decoration-none' href='/del/leadership/anwar-ul-haq'>
                                <Image src='/assets/team/8.png' alt='Anwar Ul Haq' className='mb-3' height={180} width={500} />
                                <div className='m6'>
                                    <p className='fs-6 fw-bold'>Anwar Ul Haq</p>
                                    <p>President - Industrial Services</p>
                                </div>
                            </Link>
                        </div>
                        <div className="col-lg-3 col mb-5">
                            <Link className='text-decoration-none' href='/del/leadership/syed-abdul-moeed'>
                                <Image src='/assets/team/12.png' alt='Syed Abdul Moeed' className='mb-3' height={180} width={500} />
                                <div className='m6'>
                                    <p className='fs-6 fw-bold'>Syed Abdul Moeed</p>
                                    <p>President - Construction Division</p>
                                </div>
                            </Link>
                        </div>
                        <div className="col-lg-3 col mb-5">
                        <Link   className='text-decoration-none' href='/del/leadership/steven-platts'> 
                            <Image src='/assets/team/steven-platts.png' alt='Steven Platts' className='mb-3' height={180} width={500} />
                            <div className='m6'>
                            <p className='fs-6 fw-bold'>Steven Platts</p>
                            <p>Chief Health, Safety & Environment Officer</p>
                        </div> 
                        </Link>
                        </div>
                        
                        <div className="col-lg-3 col mb-5">
                            <Link className='text-decoration-none' href='/del/leadership/kinan-raslan'>
                                <Image src='/assets/team/raslan.png' alt='Kinan Raslan' className='mb-3' height={180} width={500} />
                                <div className='m6'>
                                    <p className='fs-6 fw-bold'>Kinan Raslan</p>
                                    <p>Chief Strategy Officer</p>
                                </div>
                            </Link>
                        </div>
                        <div className="col-lg-3 col mb-5">
                            <Link className='text-decoration-none' href='/del/leadership/abdul-sohail'>
                                <Image src='/assets/team/7.png' alt='Abdul Sohail' className='mb-3' height={180} width={500} />
                                <div className='m6'>
                                    <p className='fs-6 fw-bold'>Abdul Sohail</p>
                                    <p>Chief Corporate Affairs</p>
                                </div>
                            </Link>
                        </div>
                        <div className="col-lg-3 col mb-5">
                            <Link className='text-decoration-none' href='/del/leadership/muhammad-khawar-khan'>
                                <Image src='/assets/team/3.png' alt='Muhammad Khawar Khan' className='mb-3' height={180} width={500} />
                                <div className='m6'>
                                    <p className='fs-6 fw-bold'>Muhammad Khawar Khan</p>
                                    <p>Chief Risk & Compliance Officer</p>
                                </div>
                            </Link>
                        </div>
                        <div className="col-lg-3 col mb-5">
                            <Link className='text-decoration-none' href='/del/leadership/yasir-siddique'>
                                <Image src='/assets/team/1.png' alt='Yasir Siddique' className='mb-3' height={180} width={500} />
                                <div className='m6'>
                                    <p className='fs-6 fw-bold'>Yasir Siddique</p>
                                    <p>Chief Financial Officer</p>
                                </div>
                            </Link>
                        </div>
                        <div className="col-lg-3 col mb-5">
                            <Link className='text-decoration-none' href='/del/leadership/murtuza-ali'>
                                <Image src='/assets/team/14.png' alt='Murtuza Ali' className='mb-3' height={180} width={500} />
                                <div className='m6'>
                                    <p className='fs-6 fw-bold'>Murtuza Ali</p>
                                    <p>Chief Manpower and People Services</p>
                                </div>
                            </Link >
                        </div>
                        <div className="col-lg-3 col mb-5">
                            <Link className='text-decoration-none' href='/del/leadership/maqsood-ali'>
                                <Image src='/assets/team/13.png' alt='Maqsood Ali' className='mb-3' height={180} width={500} />
                                <div className='m6'>
                                    <p className='fs-6 fw-bold'>Maqsood Ali</p>
                                    <p>Chief Human Resources Officer</p>
                                </div>
                            </Link>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    )
}

export default Leadership
