import React, { useEffect } from 'react'
import Heading from '../components/who we are/heading'
import Intro1 from '../components/who we are/intro1'
import Intro2 from '../components/who we are/intro2'
import Stats from '../components/who we are/stats'
import Tabing from '../components/who we are/tabing'
import Values from '../components/who we are/values'
import Layout from './_layout'
import ReactGA from 'react-ga'; // Import react-ga
import Head from 'next/head';

function Whoweare() {
  useEffect(() => {
    if (typeof window !== 'undefined') {
      ReactGA.pageview(window.location.pathname + window.location.search);
      console.log('Tracked Page View:', window.location.pathname);
    }
  }, []);
  return (
    <>
     <Head>
        <title>Who we are | Descon</title>
        <meta name="description" content="Descon, headquartered out of Pakistan, is a multinational conglomerate that operates in the engineering, power, chemicals, and agriculture sectors." key="desc" />
        <meta property="og:title" content="Who we are " />
        <meta property="og:description"content="Descon, headquartered out of Pakistan, is a multinational conglomerate that operates in the engineering, power, chemicals, and agriculture sectors."/>
        <meta property="og:image"content="/assets/banner-who-we-are.png"/>
      </Head>
      <Layout>
        <Heading />
        <Intro1 />
        <Stats />
        <Intro2 />
        <Values />
        <Tabing />
      </Layout>
    </>
  )
}

export default Whoweare