import React from 'react'
import Head from 'next/head'
import Layout from '../_layout'
import Image from 'next/image'

const Details10 = () => {
  return (
    <>
      <Head>
        <title>Aabroo | Descon</title>
        <meta name="description" content="Descon's global presence spreads across United Arab Emirates, Saudi Arabia and Qatar from where new ventures are executed in Kuwait, Iraq, Oman and Egypt. The development and manufacturing of industrial process equipment and piping spool takes effect from our state-of-the-art plant. The strength of our experienced project team carrying operations have the essential ISO, OHSAS and ASME certifications in addition to our own QA & QC and HSE standards." key="desc" />
        <meta property="og:title" content="Aabroo " />
        <meta property="og:description" content="Descon's global presence spreads across United Arab Emirates, Saudi Arabia and Qatar from where new ventures are executed in Kuwait, Iraq, Oman and Egypt. The development and manufacturing of industrial process equipment and piping spool takes effect from our state-of-the-art plant. The strength of our experienced project team carrying operations have the essential ISO, OHSAS and ASME certifications in addition to our own QA & QC and HSE standards." />
        <meta property="og:image" content="https://www.descon.com/en/img/logo.png" />
      </Head>
      <Layout>

        <div className="detail-mainheading">
          <div className="container ">
            <div className="row ">
              <div className="col-lg-6 col-12 my-auto ">
              </div>
            </div>
          </div>
        </div>
        <div className="container topspacer">
          <div className='row'>
            <div className='col-lg-6'>
              <Image src='/assets/socialimpact/056.jpg' alt='social056' height={180} width={800} className='img-fluid detailsimg' />
            </div>
            <div className='col-lg-6'>
              <h2 className='fw-bold'>
                Aabroo
              </h2>
              <p>
                Descon has formally commissioned and handed over a multi stage water filtration plant to the Aabroo Girls High School. The school is part of the Aabroo Educational Welfare Organization, an NGO providing free education to 3000 children currently studying in eight schools run by the Organization. The NGO is also responsible for the provision of free books, stationary and uniforms as well as lunch and milk to younger children and the students.
              </p>
              <p>
                Aabroo collects used items and solid waste from 6000 houses and offices all over Lahore, including Descon and arranges the disposal of the waste in an organized manner. This leads to the generation of funds required by Aabroo to support their cause. Descon recently through its CSR initiative, decided to further help Aabroo in its noble cause by gifting the water filtration cum RO Plant that would provide bacteria free drinking water to almost 750 students of the Aabroo Girls High School.
              </p>
              <p>
                As the water available in the area where the school was located was highly brackish, a Reverse Osmosis Plant had to be added downstream of the water filtration plant to supply sweet water. The funds for the procurement of the RO plant were generated through a very successful Bake &amp; Sale event organized at Descon Headquarters.
              </p>
              <p>
                The water filtration cum RO plant boasting a capacity of 200 litres per hour is part of many initiatives taken by Descon through its CSR to give back to the community.
              </p>
            </div>
          </div>
        </div>
      </Layout>
    </>
  )
}

export default Details10