import React, { useEffect, useState } from 'react'
import NewsCard from './newscard';
import axios from 'axios';
import Image from 'next/image';
import { Tab, Nav } from 'react-bootstrap';
import Videos from '../../components/media/videos';
import Head from 'next/head';
import Headingmedia from '../../components/media/headingmedia';
import Mediaintro from '../../components/media/mediaintro';
import Layout from '../_layout';
import Lettercard from './lattercards';
import { BsSearch } from 'react-icons/bs';



const NewsEvents = ({ newz, htmlData, newslatter}) => {

    const [newsx, setNews] = useState(newz);
    const [letter, setLetter] = useState(newslatter);

    const [showMore, setShowMore] = useState(false);
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        if (newz?.length > 0) {
            setLoading(false)
            setNews(newz)
        }
    }, [newz])

    useEffect(() => {
        if (newslatter?.length > 0) {
            setLoading(false)
            setLetter(newslatter)
        }
    }, [newslatter])


    const newsToShow = showMore ? newsx : (newsx ? newsx.slice(0, 6) : []);

    const [activeTab, setActiveTab] = useState('tab1');
    const handleTabSelect = (eventKey) => {
        setActiveTab(eventKey);
    };

    useEffect(() => {
    // API se titles fetch karein aur state mein set karein
    axios.get("URL_for_titles")
        .then(response => {
            const titles = response.data; // Assuming API returns an array of titles
            setTitles(titles);
        })
        .catch(error => {
            console.error("Error fetching titles: ", error);
        });

    // API se dates fetch karein aur state mein set karein
    axios.get("URL_for_dates")
        .then(response => {
            const dates = response.data; // Assuming API returns an array of dates
            setDates(dates);
        })
        .catch(error => {
            console.error("Error fetching dates: ", error);
        });
}, []);

    
    return (
        <>
            <Head>
                <title>Media | Descon</title>
                <meta name="description" content="The company has a strong workforce of over 12,000 employees, with expertise in various engineering disciplines, including mechanical, electrical, civil, and process engineering." key="desc" />
                <meta property="og:title" content="Media " />
                <meta property="og:description" content="The company has a strong workforce of over 12,000 employees, with expertise in various engineering disciplines, including mechanical, electrical, civil, and process engineering." />
                <meta property="og:image" content="/media.jpg" />
            </Head>
            <Layout>
                <Headingmedia />
                <Mediaintro />
                <div className='container'>
                    <div className='row'>
                        <div className='col-lg-12 col-12 mx-auto mt-5'>
                            <Tab.Container activeKey={activeTab} onSelect={handleTabSelect}>
                                <Nav variant="tabs" className='mediatabs'>
                                    <Nav.Item>
                                        <Nav.Link eventKey="tab1">News & Events</Nav.Link>
                                    </Nav.Item>
                                    <Nav.Item>
                                        <Nav.Link eventKey="tab2">Newsletter</Nav.Link>
                                    </Nav.Item>
                                    <Nav.Item>
                                        <Nav.Link eventKey="tab3">Videos</Nav.Link>
                                    </Nav.Item>
                                </Nav>
                                <Tab.Content>
                                    <Tab.Pane eventKey="tab1" >
                                        <div className='mt-5 pb-5'>
                                            <div className="container">
                                                <div className="row d-none">
                                                    <div className="col-4">
                                                        <label htmlFor="titleSelect" className="form-label">Title</label>
                                                        <select className="form-select" id="titleSelect" aria-label="Title" defaultValue="1" >
                                                            <option value="1" disabled>Select</option>
                                                            <option value="2">One</option>
                                                            <option value="3">Two</option>
                                                            <option value="4">Four</option>
                                                        </select>
                                                    </div>
                                                    <div className="col-4">
                                                        <label htmlFor="dateSelect" className="form-label">Publish Date</label>
                                                        <select className="form-select" id="dateSelect" aria-label="Publish Date" defaultValue="1">
                                                            <option value="1" disabled>Select</option>
                                                            <option value="2">One</option>
                                                            <option value="3">Two</option>
                                                            <option value="4">Four</option>
                                                        </select>
                                                    </div>
                                                    <div className="col-4">
                                                        <div className="input-group">
                                                            <input
                                                                type="text"
                                                                placeholder="What are you searching ?"
                                                                className="form-control"
                                                                style={{
                                                                    borderRadius: "0px",
                                                                    border: "none", // Border ko hide karein
                                                                    borderBottom: "2px solid #0066B3", // Blue color ke border-bottom
                                                                    outline: "none", // Outline ko hide karein
                                                                    boxShadow: "none", // Shadow ko hide karein
                                                                    marginTop: "25px",
                                                                }}
                                                            />
                                                            <div className="input-group-append">
                                                                <button
                                                                    className="input-group-text clickable"
                                                                    style={{ background: "none", border: "none", marginTop: "34px", color: "#0066B3" }}
                                                                    
                                                                >
                                                                    <BsSearch />
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className='mt-5 pb-5'>
                                                <div className='mt-5'>
                                                    <h5>News & Events</h5>
                                                    <p>Stay updated with the latest happenings at Descon by
                                                        visiting our News and Events section.</p>
                                                </div>

                                                <div className="container--fluid">
                                                    <div className="row row-cols-1 row-cols-md-3 g-3" >
                                                        {loading ? (
                                                            <div className="text-center">
                                                                <Image
                                                                    src="/loading-51.gif"
                                                                    alt="Loading..."
                                                                    width={80}
                                                                    height={80}
                                                                    style={{alignItems:"center", position: "relative" }}
                                                                />
                                                            </div>
                                                        ) : newsToShow.length > 0 ? (
                                                            newsToShow.map((news, index) => {
                                                                return (
                                                                    <>
                                                                        <NewsCard key={index.id} news={news}
                                                                            isFirstCard={index === 0}
                                                                            isThirdCard={index === 2} />
                                                                        {/* {index % 3 === 2 && <div className='w-100'></div>} */}
                                                                    </>
                                                                );
                                                            })
                                                        ) : (
                                                            <div className="text-center" dangerouslySetInnerHTML={{ __html: htmlData }} />
                                                        )}
                                                    </div >
                                                </div>
                                                {!showMore && newsx?.length > 6 && (
                                                    <div className="text-center mt-3">
                                                        <button className="btn btn-primary" onClick={() => setShowMore(true)}>
                                                            View More
                                                        </button>
                                                    </div>
                                                )}

                                                {showMore && (
                                                    <div className="text-center mt-3">
                                                        <button className="btn btn-primary" onClick={() => setShowMore(false)}>
                                                            View Less
                                                        </button>
                                                    </div>
                                                )}
                                            </div>
                                        </div>
                                    </Tab.Pane>
                                    <Tab.Pane eventKey="tab2">
                                        <div className='mt-5 pb-5'>
                                            <div className="container">
                                                <div className="row d-none">
                                                    <div className="col-4">
                                                        <input type="text" placeholder="Search.." />
                                                    </div>
                                                </div>
                                            </div>
                                            <div className='mt-5'>
                                                <h5>Newsletter</h5>
                                                <p>Our newsletter is your source for the latest news and insights
                                                    on Descon. Enjoy reading the quarter-wise happenings at the Descon companies.</p>
                                            </div>
                                            <div className="container-fluid">
                                                <div className="row row-cols-1 row-cols-md-3 g-3" >
                                                    {letter && letter.length > 0 ? (

                                                        letter.slice(0, letter.length - 3).map((letter, index) => {
                                                            return (
                                                                <>
                                                                    <Lettercard key={index} letter={letter} />
                                                                </>
                                                            )
                                                        })
                                                    ) : (
                                                        <div className="text-center">
                                                            <Image src="/loading-51.gif" alt="Loading..." width={80} height={80} style={{

                                                            }} />
                                                        </div>
                                                    )
                                                    }
                                                </div >
                                            </div>
                                        </div >
                                    </Tab.Pane>
                                    <Tab.Pane eventKey="tab3">
                                        <Videos />
                                    </Tab.Pane>
                                </Tab.Content>
                            </Tab.Container>
                        </div>
                    </div>
                </div>
            </Layout>
        </>
    );
};

const convertToHtml = (newsData) => {
    return newsData.map(news => `
      <div class="news-item">
        <h3>${news.news_title}</h3>
        <p>${news.news_description}</p>
        <span>${news.news_date}</span>
      </div>
    `).join('');
};



export const getStaticProps = async () => {
    try {
        const response = await axios.get("https://descon.com/en/rest-api/news/read.php");
        const sortedNews = response.data.data.sort((a, b) => {
            const dateA = new Date(a.news_date);
            const dateB = new Date(b.news_date);
            return dateB - dateA;
        });
        const responseletter = await axios.get("https://descon.com/en/rest-api/newsletter/read.php");
        const sortedNewslatetter = responseletter.data.data.sort((a, b) => {
            const dateA = new Date(a.newsletter_date);
            const dateB = new Date(b.newsletter_date);
            return dateB - dateA;
        });

        const htmlData = convertToHtml(sortedNews);
        return {
            props: {
                newz: sortedNews,
                newslatter: sortedNewslatetter,
                htmlData: htmlData,
            }
        };
    } catch (error) {
        console.error("Error fetching news:", error);
        return {
            props: {
                newz: [],
                newslatter: [],
                htmlData: '', // Return an empty array if there's an error
            }
        };
    }
};

export default NewsEvents