import Image from 'next/image';
import Link from 'next/link';
import React from 'react';

const Latesthomenews = ({ news, maxDescriptionLength = 250, isFirstCard }) => {
    if (!news) {
        // Handle the case when news is undefined or null
        return null; // Or any other fallback UI or message you want to display
    }

    const formattedDate = new Date(news.news_date).toLocaleString('en-US', {
        month: 'long',
        day: 'numeric',
        year: 'numeric',
    });

    const stripHtmlTags = (htmlString) => {
        const doc = new DOMParser().parseFromString(htmlString, 'text/html');
        return doc.body.textContent || '';
    };

    const cleanedDescription = stripHtmlTags(news.news_description);

    const truncatedDescription =
        cleanedDescription.length > maxDescriptionLength
            ? cleanedDescription.slice(0, maxDescriptionLength - 4) + '...'
            : cleanedDescription;

    const titleLines = isFirstCard ? 1.5 : 2;
    const titleMaxHeight = 1.3 * titleLines + 'em';
    cleanedDescription.length > maxDescriptionLength


    return (
        <div className='col-lg-4 col-12 mb-5'>
            <div className='mt-5'>
                <Image src={news.media_url} alt="homepage news" className='img-fluid' width={416} height={227} layout='responsive' />
                <Link href={'/news/[id]'} as={`/news/${encodeURIComponent(news.news_meta)}`}
                    className='fw-bold fs-6 text-decoration-none text-dark'>
                    <div>
                        {news.news_title}
                    </div>
                </Link>
                <p className='fw-bold text-danger mt-2'>{formattedDate}</p>
                <p className='mt-2 '>
                    {truncatedDescription}
                </p>
            </div>
        </div>
    )
}

export default Latesthomenews;
