import Head from 'next/head';
import Image from 'next/image';
import Layoutinvestment from '../../_layoutinvestment';

const TeamDetail = () => {
    return (
        <>
            <Head>
                <title>Faisal Dawood | Descon</title>
                <meta name="description" content="Faisal Dawood is the Vice Chairman of Descon. He is also a member of the various Descon companies’ Board of Directors, along with DTI." key="desc" />
                <meta property="og:title" content="Faisal Dawood| Descon" />
                <meta property="og:description" content="Faisal Dawood is the Vice Chairman of Descon. He is also a member of the various Descon companies’ Board of Directors, along with DTI." />
                <meta property="og:image" content="https://www.descon.com/en/img/logo.png" />
            </Head>
            <Layoutinvestment>
                <div className="mainheading mainheadingteam"
                    style={{
                        backgroundImage: `url('/assets/bod.jpg')`,
                        backgroundSize: 'cover',
                        backgroundRepeat: 'no-repeat',
                    }}
                >
                    <div className="container ">
                        <div className="row ">
                            <div className="col-lg-6 col-12 my-auto">
                                <h1 className='fw-bold'>Faisal Dawood<br />
                                    <span>Vice-Chairman, Descon</span></h1>
                            </div>
                        </div>
                    </div>
                </div>
                <div className="container topspacer">
                    <div className='row justify-content-center'>
                        <div className='col-lg-3 col-md-3 col-12 text-center'>
                            <Image src="/assets/investment/faisal-dawood.png" alt='team_image_url' height={180} width={500} className='img-fluid detailsimg' />
                        </div>
                        <div className='col-md-9 col-12 my-auto'>
                            <p>Faisal Dawood is the Vice Chairman of Descon. He is also a member of the various Descon companie&apos;s Board of Directors, along with DTI. Since joining Descon in 2000, Faisal has served in a variety of engineering and chemicals management positions and executive management positions around the world.</p>
                            <p>Prior to these assignments, Faisal was located in Abu Dhabi, in his position as Head International Business Development of Descon Engineering, responsible for all business in the GCC region. Faisal was heading Descon&apos;s Engineering Manufacturing Division and was based at the manufacturing facility in Sharjah. He has also served as Head Project Management System and Treasury Manager for Descon Engineering in Lahore.</p>
                            <p>Faisal Dawood holds a Bachelor of Science Degree in Materials Science and Engineering(MSE) from Cornell University and a Master&apos;s Degree in Business Administration from Columbia University. He currently leads Power & Chemicals businesses of Descon, in addition to managing Descon&apos;s diversification portfolio. He is serving on the Board of the National Management Foundation at the prestigious Lahore University of Management Sciences (LUMS).</p>
                        </div>
                    </div>
                </div>
            </Layoutinvestment>
        </>
    );
};


export default TeamDetail;