import React from 'react'
import Head from 'next/head'
import dynamic from 'next/dynamic';
import Layoutinvestment from '../_layoutinvestment';
import Link from 'next/link';
import Image from 'next/image';
import Mangement from '../../components/Investment/mangement';
const Investheading = dynamic(() => import('../../components/Investment/Investheading'));
const Investintro = dynamic(() => import('../../components/Investment/Investintro'));
const Ourinvestments = dynamic(() => import('../../components/Investment/ourinvestment'));

const Investments = () => {

  return (
    <>
      <Head>
        <title>Descon Investments - About  | Descon</title>
        <meta name="description" content="In pursuit of diversification, Descon has strategically invested in various businesses through Descon Capital, the investment arm of the Descon conglomerate." key="desc" />
        <meta property="og:title" content="Descon Investments - About " />
        <meta property="og:description" content="In pursuit of diversification, Descon has strategically invested in various businesses through Descon Capital, the investment arm of the Descon conglomerate." />
        <meta property="og:image" content="'/assets/dol/about/dol-bg.png" />
      </Head>
      <Layoutinvestment>
        <Investheading />
        <Investintro />
        <Ourinvestments />
        <Mangement />
      </Layoutinvestment>
    </>
  )
}


export default Investments