import React, { useEffect, useState } from 'react';
import Busniessunit from '../components/home/busniessunit';
import Homeheading from '../components/home/heading';
import Layout from './_layout';
import Head from 'next/head';
import axios from 'axios';
import Image from 'next/image';
import Latesthomenews from './lateshomenews';


const Home = ({ newz, htmlData }) => {

  const [newsx, setNews] = useState(newz);
  const [loading, setLoading] = useState(true);
  const [showMore] = useState(false);
  
  useEffect(() => {
    if (newz?.length > 0) {
        setLoading(false)
        setNews(newz)
    }
}, [newz]);


const newsToShow = showMore ? newsx : (newsx ? newsx.slice(0, 3) : []);

  // useEffect(() => {
  //   if (typeof window !== 'undefined') {
  //     ReactGA.pageview(window.location.pathname + window.location.search);
  //     console.log('Tracked Page View:', window.location.pathname);
  //   }
  // }, []);
  return (
    <>
      <Head>
        <title>Home | Descon</title>
        <meta property="og:title" content="Home" />
        <meta property="og:description" content="Descon's global presence spreads across United Arab Emirates, Saudi Arabia and Qatar from where new ventures are executed in Kuwait, Iraq, Oman and Egypt. The development and manufacturing of industrial process equipment and piping spool takes effect from our state-of-the-art plant. The strength of our experienced project team carrying operations have the essential ISO, OHSAS and ASME certifications in addition to our own QA & QC and HSE standards." />
        <meta property="og:image" content="/assets/logo-descon.png" />
      </Head>
      <Layout>
        <Homeheading />
        <Busniessunit />
        {/* <Latestupdates /> */}
        <div className='container fullwidth latestupdate'>
                <div className='row'>
                    <div className="col-12 mx-auto text-center mb-1 mt-5">
                        <h3 className='fw-bold'>Latest Updates</h3>
                        <div className='underline mx-auto'></div>
                    </div>
                    <div className="container--fluid">
                        <div className="row row-cols-1 row-cols-md-3 g-3" >
                            {loading ? (
                                <div className="text-center">
                                </div>
                            ) : newsToShow.length > 0 ? (
                                newsToShow.map((news, index) => {
                                    return (
                                        <>
                                            <Latesthomenews
                                                key={index}
                                                news={news}
                                                isFirstCard={index === 0}
                                            />
                                        </>
                                    )
                                })
                            ) : (
                                <div className="text-center" dangerouslySetInnerHTML={{ __html: htmlData }} />
                            )
                            }
                        </div >
                    </div>
                </div>
            </div>
      </Layout>
    </>
  );
};

const convertToHtml = (newsData) => {
  return newsData.map(news => `
    <div class="news-item">
      <h3>${news.news_title}</h3>
      <p>${news.news_description}</p>
      <span>${news.news_date}</span>
    </div>
  `).join('');
};

export const getStaticProps = async () => {
  try {
      const response = await axios.get("https://descon.com/en/rest-api/news/read.php");
      const sortedNews = response.data.data.sort((a, b) => {
          const dateA = new Date(a.news_date);
          const dateB = new Date(b.news_date);
          return dateB - dateA;
      });

      const htmlData = convertToHtml(sortedNews);

      return {
          props: {
              newz: sortedNews,
              htmlData: htmlData,
          }
      };
  } catch (error) {
      console.error("Error fetching news:", error);
      return {
          props: {
              newz: [],
              htmlData: '', // Return an empty array if there's an error
          }
      };
  }
};

export default Home;
