import ReactHtmlParser from 'html-react-parser';
import Head from 'next/head';
import Image from 'next/image';
import axios from 'axios';
import Layoutdol from '../../_layoutdol';

const TeamDetail = () => {
    return (
        <>
            <Head>
                <title>Abdul Sohail| Descon</title>
                <meta name="description" content="Mr. Sohail has an M.Com from the University of Punjab, Lahore and has been with Descon for almost 2 decades. As Company Secretary and Chief Corporate Affairs, he is responsible for all matters pertaining to the organization’s legal aspects, as well as Taxation and the incorporation and establishment of Joint Ventures and Companies within the group." key="desc" />
                <meta property="og:title" content="Abdul Sohail| Descon" />
                <meta property="og:description" content="Mr. Sohail has an M.Com from the University of Punjab, Lahore and has been with Descon for almost 2 decades. As Company Secretary and Chief Corporate Affairs, he is responsible for all matters pertaining to the organization’s legal aspects, as well as Taxation and the incorporation and establishment of Joint Ventures and Companies within the group." />
                <meta property="og:image" content="https://www.descon.com/en/img/logo.png" />
            </Head>
            <Layoutdol>
                <div className="mainheading mainheadingteam"
                    style={{
                        backgroundImage: `url('/assets/bod.jpg')`,
                        backgroundSize: 'cover',
                        backgroundRepeat: 'no-repeat',
                    }}
                >
                    <div className="container ">
                        <div className="row ">
                            <div className="col-lg-6 col-12 my-auto">
                                <h1 className='fw-bold'>Abdul Sohail<br />
                                    <span>Company Secretary</span></h1>
                            </div>
                        </div>
                    </div>
                </div>
                <div className="container topspacer">
                    <div className='row justify-content-center'>
                        <div className='col-lg-3 col-md-3 col-12 text-center'>
                            <Image src="/assets/dol/company-info/profilegovernance/abdul-sohail01.png" alt='team_image_url' height={180} width={500} className='img-fluid detailsimg' />
                        </div>
                        <div className='col-md-9 col-12 my-auto'>
                            <p>Mr. Sohail has an M.Com from the University of Punjab, Lahore and has been with Descon for almost 2 decades. As Company Secretary and Chief Corporate Affairs, he is responsible for all matters pertaining to the organization’s legal aspects, as well as Taxation and the incorporation and establishment of Joint Ventures and Companies within the group.</p>
                        </div>
                    </div>
                </div>
            </Layoutdol>
        </>
    );
};


export default TeamDetail;