import React from 'react'
import Link from 'next/link';
import Image from 'next/image';

const ShareHolding = ({ shares }) => {
    if (!shares || !shares.file_name || !shares.title) {
        return <div>Error: Invalid shares data</div>;
    }

    return (
        <>
            <div className='pdfsspacers'>
                <Link target='_blank' href={shares.file_name}>
                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={20} height={20} layout='responsive' />
                </Link>
            <p className='mb-2 mt-3'>{shares.title}</p>
            </div>
        </>
    )
}

export default ShareHolding;
