import React from 'react'
import Link from 'next/link';
import Image from 'next/image';

const Quarterlyreport = ({ quaterreport }) => {
    if (!quaterreport || !quaterreport.file_name || !quaterreport.title) {
        return <div>Error: Invalid quarterly report data</div>;
    }

    return (
        <div className='pdfsspacers text-center bg-white p-1 border rounded-3'>
            <Link target='_blank' href={quaterreport.file_name}>
                <Image src='/assets/pdficon.png' className='img-fluid p-4' alt="" width={416} height={227} layout='responsive' />
                <p>{quaterreport.title}</p>
            </Link>
        </div>
    )
}

export default Quarterlyreport;
