import React from 'react'
import Link from 'next/link';
import Image from 'next/image';

const Investorprestation = ({  investor }) => {
    if (!investor || !investor.file_name) {
        // Check if 'investor' is undefined or 'file_name' is missing
        return <div>Error: Invalid investor data</div>;
    }

    return (
        <div className='pdfsspacers '>
            <Link target='_blank' href={investor.file_name}>
                <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={416} height={227} layout='responsive' />
                <p className='mb-2 mt-3'>{investor.title}</p>
            </Link>
        </div>
    )
}

export default Investorprestation;
