import React from 'react'
import Link from 'next/link';
import Image from 'next/image';

const Anuualreport = ({ report }) => {
    if (!report || !report.file_name || !report.title) {
        // Check if 'report' is undefined or 'file_name' and 'title' are missing
        return <div>Error: Invalid report data</div>;
    }
    
    return (
        <div className='pdfsspacers text-center bg-white p-2 border rounded-3'>
            <Link target='_blank' href={report.file_name}>
                <Image src='/assets/pdficon.png' className='img-fluid p-4' alt="" width={416} height={227} layout='responsive' />
                <p>{report.title}</p>
            </Link>
        </div>
    )
}
// console.log("msg", report.file_name) 

export default Anuualreport;
