import React from 'react'
import Link from 'next/link';
import Image from 'next/image';

const Compliancecertificate = ({ compliance }) => {
    if (!compliance || !compliance.file_name) {
        // Check if 'compliance' is undefined or 'file_name' is missing
        return <div>Error: Invalid compliance data</div>;
    }

    return (
        <div className='pdfsspacers'>
            <Link target='_blank' href={compliance.file_name}>
                <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={416} height={227} layout='responsive' />
                <p className='mb-2 mt-3'>{compliance.title}</p>
            </Link>
        </div>

    )
}

export default Compliancecertificate;
