import React, { useEffect, useState } from 'react'

import Head from 'next/head'
import Layoutdel from '../_layoutdel';
import Delheading from '../../components/DEL/delheading'
import Delintro from '../../components/DEL/delintro'
import dynamic from 'next/dynamic';
import axios from 'axios';
import Image from 'next/image';
import Boadofdirector from './bod';
import Teammembers from './team';
const Ceomessage = dynamic(() => import('../../components/DEL/ceomessage'));
const Visionintro = dynamic(() => import('../../components/DEL/visionintro'));
const Purposeintro = dynamic(() => import('../../components/DEL/purposeintro'));
const Boardofdirectors = dynamic(() => import('../../components/DEL/boardofdirectors'));
const Leadership = dynamic(() => import('../../components/DEL/leadership'));
const Globalpresence = dynamic(() => import('../../components/DEL/globalpresence'));


const DEL = ({ leaders, htmlData, bod }) => {


  const [membersx, setMembers] = useState(leaders);
  const [director, setDirector] = useState(bod);
  const [loading, setLoading] = useState(true);
  // const [showMore] = useState(false);

  useEffect(() => {
    if (leaders?.length > 0) {
      setLoading(false)
      setMembers(leaders)
    }
  }, [leaders]);


  useEffect(() => {
    if (bod?.length > 0) {
      setLoading(false)
      setDirector(bod)
    }
  }, [bod]);


  return (
    <>
      <Head>
        <title>Descon Engineering Limited - About  | Descon</title>
        <meta name="description" content="Descon Engineering Limited is a multinational engineering company renowned globally for its quality, safety and on-time delivery of projects and products." key="desc" />
        <meta property="og:title" content="Descon Engineering Limited - About " />
        <meta property="og:description" content="Descon Engineering Limited is a multinational engineering company renowned globally for its quality, safety and on-time delivery of projects and products." />
        <meta property="og:image" content="/assets/del-bg.JPG" />
      </Head>
      <Layoutdel>
        <Delheading />
        <Delintro />
        <Ceomessage />
        <Visionintro />
        <Purposeintro />
        {/* <Boardofdirectors /> */}
        <div className="bg-light boardofdirector">
          <div className="container text-center">
            <div className='mb-5 col-md-8 mx-auto'>
              <h1>Board Of Directors</h1>
              <p>Descon Engineering&apos;s Board of Directors includes five non-executive directors and one independent director.
                The Board has the collective responsibility for ensuring that company&apos;s matters are managed competently and with integrity.</p>
            </div>
            <div className="row align-items-center text-center bod">
              {
                loading ? (
                  <div className="text-center">
                    <Image
                      src="/assets/loading-51.gif"
                      alt="Loading..."
                      width={80}
                      height={80}
                    />
                  </div>
                ) : director && director.length > 0 ? (
                  director.map((bod, index) => {
                    return (
                      <Boadofdirector
                        key={index}
                        bod={bod}
                      />
                    )
                  })
                ) : (
                  <div className="text-center" dangerouslySetInnerHTML={{ __html: htmlData }} />
                )
              }
            </div >
          </div >
        </div >
        {/* <Leadership /> */}
        <div className='bg-leadership p-5 position-relative'>
          <div className='mb-5 col-md-10 mx-auto'>
            <h1>Leadership Team</h1>
            <p className='text-white'>Descon Engineering’s leadership team comprises competent and experienced individuals. They are responsible for conceptualizing and articulating goals that bring our people together in pursuit of set objectives. They lead the company with firm commitment to the values and vision of Descon Engineering.</p>
          </div>
          <div className="box-leadership">
            <div className="container">
              <div className="row align-items-center text-center bod zindex1 position-relative " >
                {
                  loading ? (
                    <div className="text-center">
                      <Image
                        src="/assets/loading-51.gif"
                        alt="Loading..."
                        width={80}
                        height={80}
                      />
                    </div>
                  ) : membersx && membersx.length > 0 ? (
                    membersx.map((members, index) => {
                      return (
                        <Teammembers
                          key={index}
                          members={members}
                        />
                      )
                    })
                  ) : (
                    <div className="text-center" dangerouslySetInnerHTML={{ __html: htmlData }} />
                  )
                }
              </div >
            </div >
          </div >
        </div >
        <Globalpresence />
      </Layoutdel>
    </>
  )
}


const convertToHtml = (membersData) => {
  return membersData.map(members => `
        <div class="members-item">
          <h3>${members.team_name}</h3>
          <p>${members.team_desig}</p>
          <span>${members.timestamp}</span>
        </div>
        `).join('');
};


export const getStaticProps = async () => {
  try {
    const response1 = await axios.get("https://descon.com/en/rest-api/teams/read.php?verticals=del&view_status=y&type_of_team=leader");
    let sortedTeam = response1.data.data.sort((a, b) => {
      const dateA = new Date(a.timestamp);
      const dateB = new Date(b.timestamp);
      return dateB - dateA;
    });

    const response2 = await axios.get("https://descon.com/en/rest-api/teams/read.php?verticals=del&view_status=y&type_of_team=bod");
    let sortedbod = response2.data.data.sort((a, b) => {
      const dateA = new Date(a.timestamp);
      const dateB = new Date(b.timestamp);
      return dateB - dateA;
    });

    sortedTeam = sortedTeam.reverse();
    sortedbod = sortedbod.reverse();

    const htmlData1 = convertToHtml(sortedTeam);
    const htmlData2 = convertToHtml(sortedbod);

    return {
      props: {
        leaders: sortedTeam,
        bod: sortedbod,
        htmlData: htmlData1,
      }
    };
  } catch (error) {
    console.error("Error fetching members:", error);
    return {
      props: {
        leaders: [],
        bod: [],
        htmlData: '', // Return an empty array if there's an error
      }
    };
  }
};



export default DEL