import React, { useState } from 'react';
import { Tab, Nav } from 'react-bootstrap';
import Link from 'next/link';



function Socialtab() {
    const [activeTab, setActiveTab] = useState('tab1');

    const handleTabSelect = (eventKey) => {
        setActiveTab(eventKey);
    };

    return (
        <div className='container'>
            <div className='row'>
                <div className='col-lg-12 col-12 mx-auto mt-5'>
                    <Tab.Container activeKey={activeTab} onSelect={handleTabSelect}>
                        <Nav variant="tabs" className='socialtabs'>
                            <Nav.Item>
                                <Nav.Link eventKey="tab1">DESCON</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link eventKey="tab2">BARD Foundation</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link eventKey="tab3">DTI</Nav.Link>
                            </Nav.Item>
                        </Nav>
                        <Tab.Content>
                            <Tab.Pane eventKey="tab1">
                                <div className='mt-5 pb-5'>
                                    <div className="container-fluid">
                                        <div className="row row-cols-1 row-cols-md-3 g-3" >
                                            <div className="col-12 col-xl-4 col-lg-6 col-md-6">
                                                <div className='cards h-100'>
                                                    <div className="bg-socialimg4 card card-cover overflow-hidden text-white">
                                                        <div className="d-flex flex-column h-100 p-5 mt-5 ">
                                                            <h4 className="mt-5  lh-1 fw-bold text-white fs-6 ">Descon Donates Sanidol to Custom House</h4>
                                                            <ul className="d-flex list-unstyled mt-auto">
                                                                <li className="me-auto">
                                                                    <Link href='/social-impact/descon-donates-sanidol-to-custom-house' className='btn btn-sm btn-outline-light'>Read more</Link>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="col-12  col-xl-4 col-lg-6 col-md-6">
                                                <div className='cards h-100'>
                                                    <div className="bg-socialimg5 card card-cover overflow-hidden text-white">
                                                        <div className="d-flex flex-column h-100 p-5 mt-5 ">
                                                            <h4 className=" mt-5 lh-1 fw-bold text-white fs-6">Annual Blood Drive</h4>
                                                            <ul className="d-flex list-unstyled mt-auto">
                                                                <li className="me-auto">
                                                                    <Link href='/social-impact/annual-blood-drive' className='btn btn-sm btn-outline-light '>Read more</Link>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="col-12  col-xl-4 col-lg-6 col-md-6">
                                                <div className='cards h-100'>
                                                    <div className="bg-socialimg6 card card-cover overflow-hidden text-white">
                                                        <div className="d-flex flex-column h-100 p-5 mt-5 ">
                                                            <h4 className=" mt-5 lh-1 fw-bold text-white fs-6">Descon Oxychem Limited Partners With Leading Pakistani Companies To Eliminate Viral Hepatitis</h4>
                                                            <ul className="d-flex list-unstyled mt-auto">
                                                                <li className="me-auto">
                                                                    <Link href='/social-impact/descon-oxychem-limited-partners-with-leading-pakistani-companies-to-eliminate-viral-hepatitis' className='btn btn-sm btn-outline-light'>Read more</Link>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="col-12  col-xl-4 col-lg-6 col-md-6">
                                                <div className='cards h-100'>
                                                    <div className="bg-socialimg7 card card-cover overflow-hidden text-white">
                                                        <div className="d-flex flex-column h-100 p-5 mt-5 ">
                                                            <h4 className=" mt-5 lh-1 fw-bold text-white fs-6">Suleman Dawood School of Business</h4>
                                                            <ul className="d-flex list-unstyled mt-auto">
                                                                <li className="me-auto">
                                                                    <Link href='/social-impact/suleman-dawood-school-of-business' className='btn btn-sm btn-outline-light'>Read more</Link>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="col-12  col-xl-4 col-lg-6 col-md-6">
                                                <div className='cards h-100'>
                                                    <div className="bg-socialimg8 card card-cover overflow-hidden text-white">
                                                        <div className="d-flex flex-column h-100 p-5 mt-5 ">
                                                            <h4 className=" mt-5 lh-1 fw-bold text-white fs-6">Punjab Institute of Cardiology (PIC)</h4>
                                                            <ul className="d-flex list-unstyled mt-auto">
                                                                <li className="me-auto">
                                                                    <Link href='/social-impact/punjab-institute-of-cardiology' className='btn btn-sm btn-outline-light'>Read more</Link>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="col-12  col-xl-4 col-lg-6 col-md-6">
                                                <div className='cards h-100'>
                                                    <div className="bg-socialimg9 card card-cover overflow-hidden text-white">
                                                        <div className="d-flex flex-column h-100 p-5 mt-5 ">
                                                            <h4 className=" mt-5 lh-1 fw-bold text-white fs-6">Descon Donates Sanidol (Sanitizer/Disinfectant) to CCPO Lahore and IG Punjab</h4>
                                                            <ul className="d-flex list-unstyled mt-auto">
                                                                <li className="me-auto">
                                                                    <Link href='/social-impact/descon-donates-sanidol-sanitizer-disinfectant-to-ccpo-lahore-and-ig-punjab' className='btn btn-sm btn-outline-light'>Read more</Link>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="col-12  col-xl-4 col-lg-6 col-md-6">
                                                <div className='cards h-100'>
                                                    <div className="bg-socialimg10 card card-cover overflow-hidden text-white">
                                                        <div className="d-flex flex-column h-100 p-5 mt-5 ">
                                                            <h4 className=" mt-5 lh-1 fw-bold text-white fs-6">Descon Donates 10,000 kg Sanidol to Punjab Government</h4>
                                                            <ul className="d-flex list-unstyled mt-auto">
                                                                <li className="me-auto">
                                                                    <Link href='/social-impact/descon-donates-10000kg-sanidol-to-punjab-government' className='btn btn-sm btn-outline-light'>Read more</Link>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="col-12  col-xl-4 col-lg-6 col-md-6">
                                                <div className='cards h-100'>
                                                    <div className="bg-socialimg11 card card-cover overflow-hidden text-white">
                                                        <div className="d-flex flex-column h-100 p-5 mt-5 ">
                                                            <h4 className=" mt-5 lh-1 fw-bold text-white fs-6">Contributions to Namal College</h4>
                                                            <ul className="d-flex list-unstyled mt-auto">
                                                                <li className="me-auto">
                                                                    <Link href='/social-impact/contributions-to-namal-college' className='btn btn-sm btn-outline-light'>Read more</Link>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="col-12  col-xl-4 col-lg-6 col-md-6">
                                                <div className='cards h-100'>
                                                    <div className="bg-socialimg12 card card-cover overflow-hidden text-white">
                                                        <div className="d-flex flex-column h-100 p-5 mt-5 ">
                                                            <h4 className=" mt-5 lh-1 fw-bold text-white fs-6">CARE Foundation</h4>
                                                            <ul className="d-flex list-unstyled mt-auto">
                                                                <li className="me-auto">
                                                                    <Link href='/social-impact/care-foundation' className='btn btn-sm btn-outline-light'>Read more</Link>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div className="col-12  col-xl-4 col-lg-6 col-md-6">
                                                <div className='cards h-100'>
                                                    <div className="bg-socialimg13 card card-cover overflow-hidden text-white">
                                                        <div className="d-flex flex-column h-100 p-5 mt-5 ">
                                                            <h4 className=" mt-5 lh-1 fw-bold text-white fs-6">Aabroo</h4>
                                                            <ul className="d-flex list-unstyled mt-auto">
                                                                <li className="me-auto">
                                                                    <Link href='/social-impact/aabroo' className='btn btn-sm btn-outline-light'>Read more</Link>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div >
                                    </div>
                                </div>
                                
                            </Tab.Pane>
                            <Tab.Pane eventKey="tab2">
                                <div className='mt-5 pb-5'>
                                    <div className='mt-5'>
                                        <h5>Bilquis & Abdul Razak Dawood (BARD) Foundation</h5>
                                        <p>
                                            A not-for-profit organization working towards Sports, Education and Social Welfare of the Society.
                                            BARD Foundation is an initiative undertaken by Bilquis and Abdul Razak Dawood to help talented individuals
                                            realize their potential as champions in their chosen fields. The objective of the BARD Foundation is to develop
                                            individuals, with a special emphasis on skills.
                                            To get more details, visit <br/>
                                            <Link   className='text-decoration-none btn btn-sm btn-primary mt-3 custombutton' target='_blank' href='https://bard-foundation.com/'>www.bard-foundation.com</Link>
                                        </p>
                                    </div>
                                </div >
                            </Tab.Pane>
                            <Tab.Pane eventKey="tab3">
                                <div className='mt-5 pb-5'>
                                    <div className='mt-5'>
                                        <h5>Descon Technical Institute</h5>
                                        <p>
                                            A project by the Bilquis and Abdul Razak Dawood (BARD) Foundation and a CSR wing of Descon, DTI was established in 1998 to bridge the gap between education & employment by providing technical and vocational skills to the youth of Pakistan. It  gained NPO status in 2014 from the Pakistan institute of Philanthropy in recognition of its services to the country.
                                            To get more details, visit <br/>
                                            <Link   className='text-decoration-none btn btn-sm btn-primary mt-3 custombutton' target='_blank' href='https://www.dti.edu.pk/'>www.dti.edu.pk</Link>
                                        </p>
                                    </div>
                                </div >
                            </Tab.Pane>
                        </Tab.Content>
                    </Tab.Container>
                </div>
            </div>
        </div>
    );
}

export default Socialtab;