import React, { useEffect, useState } from 'react'
import Link from 'next/link'
import NewsCard from './newscard';
import axios from 'axios';
import Image from 'next/image';




const Newsevents = ({newz}) => {

  const [newsx, setNews] = useState(newz);

  const [showMore, setShowMore] = useState(false);
  const [loading, setLoading] = useState(true);



  // useEffect(() => {
  //   setTimeout(async () => {
  //     axios.get("https://descon.com/en/rest-api/news/read.php")
  //       .then((response) => {
  //         const sortedNews = response.data.data.sort((a, b) => {
  //           const dateA = new Date(a.news_date);
  //           const dateB = new Date(b.news_date);
  //           return dateB - dateA;
  //         });
  //         setNews(sortedNews);
  //         setLoading(false)
  //       }).catch((err) => {
  //         console.log(err, "Error")
  //         setLoading(false);
  //       });
  //   }, 1000)
  // }, [])


  useEffect(() => {
    if (newz?.length > 0) {
      setLoading(false)
      setNews(newz)
    }
  }, [newz])
  const newsToShow = showMore ? newsx : (newsx ? newsx.slice(0, 6) : []);


  return (
    <div className='mt-5 pb-5'>
      {/* <div className="container d-none">
        <div className="row">
          <div className="col-4">
            <select className="form-select" aria-label="Default select example" defaultValue="1">
              <option selected>Open this select menu</option>
              <option value="1">One</option>
              <option value="2">Two</option>
              <option value="3">Three</option>
            </select>
          </div>
          <div className="col-4">
            <select className="form-select" aria-label="Default select example" defaultValue="1">
              <option selected>Open this select menu</option>
              <option value="1">One</option>
              <option value="2">Two</option>
              <option value="3">Three</option>
            </select>
          </div>
          <div className="col-4">
            <input type="text" placeholder="Search.." />
          </div>
        </div>
      </div> */}
      <div className='mt-5'>
        <h5>News & Events</h5>
        <p>Stay updated with the latest happenings at Descon by
          visiting our News and Events section.</p>
      </div>
      {/* <div className='container--fluid media d-none'>
        <div className='row mt-3'>
          <div className='col-lg-8 col-md-12'>
            <div className="bg-img card card-cover text-dark">
              <div className="d-flex flex-column h-100 p-5 pb-3">
                <ul className="d-flex list-unstyled mt-auto">
                  <li className="me-auto">
                    <h4 className="pt-5 mt-5 mb-4  lh-1 fw-bold text-white fs-6">DIC Pakistan Awards Project IRIS to Descon Engineering</h4>
                    <Link className='btn btn-sm btn-outline-light' href='/media/DIC-pakistan-awards-project-IRIS-to-descon-engineering'>Read more</Link>
                  </li>
                </ul>
              </div>
            </div>
          </div>
          <div className='col-lg-4 col-md-12 space-between'>
            <div className="bg-img2 card card-cover overflow-hidden text-white mb-3" >
              <div className="d-flex flex-column h-100 p-5 pb-3">
                <h4 className="pt-5 mt-5 mb-3 lh-1 fw-bold text-white fs-6">Descon Engineering Recognized by Qatargas for its HSE Practices</h4>
                <ul className="d-flex list-unstyled mt-auto">
                  <li className="me-auto">
                    <Link href='/media/descon-engineering-recognized-by-qatargas-for-its-HSE-practices' className='btn btn-sm btn-outline-light'>Read more</Link>
                  </li>
                </ul>
              </div>
            </div>
            <div className="bg-img3 card card-cover overflow-hidden text-white mb-3">
              <div className="d-flex flex-column h-100 p-5 pb-3 ">
                <h4 className="pt-5 mt-5 mb-4  lh-1 fw-bold text-white fs-6 ">DEST Makes a Breakthrough in North Africa</h4>
                <ul className="d-flex list-unstyled mt-auto">
                  <li className="me-auto">
                    <Link href='/media/DEST-makes-a-breakthrough-in-north-africa' className='btn btn-sm btn-outline-light'>Read more</Link>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div> */}
      <div className="container--fluid">
        <div className="row row-cols-1 row-cols-md-3 g-3" >
          {loading ? (
            <div className="text-center">
              <Image
                src="/loading-51.gif"
                alt="Loading..."
                width={80}
                height={80}
                style={{ marginRight: "-50rem", position: "relative" }}
              />
            </div>
          ) : newsToShow.length > 0 ? (
            newsToShow.map((news, index) => {
              return (
                <NewsCard
                  key={index}
                  news={news}
                />
              );
            })
          ) : (
            <div className="text-center">
              <p>No news data available.</p>
            </div>
          )}
        </div >
      </div>
      {!showMore && newsx?.length > 6 && (
        <div className="text-center mt-3">
          <button className="btn btn-primary" onClick={() => setShowMore(true)}>
            View More
          </button>
        </div>
      )}
    </div>
  );
};

export const getServerSideProps = async () => {
  try {
    const response = await axios.get("https://descon.com/en/rest-api/news/read.php");
    const sortedNews = response.data.data.sort((a, b) => {
      const dateA = new Date(a.news_date);
      const dateB = new Date(b.news_date);
      return dateB - dateA;
    });
    console.log("data:", sortedNews)
    return {
      props: {
        newz: sortedNews,
      }
    };
  } catch (error) {
    console.error("Error fetching news:", error);
    return {
      props: {
        newz: [], // Return an empty array if there's an error
      }
    };
  }
};


export default Newsevents
