import React from 'react'
import Image from 'next/image'

const Qhseintro = () => {
    return (
        <div className='container spacer' style={{ paddingTop: '2rem' }}>
            <div className='row'>
                <div className=' col-12'>    
                  <h2>HSE Milestones: Where Safety is the Way We Work</h2>               
                   <p >                     
Safety, for us, is not just a performance metric - it is a mindset that guides how we plan, operate, and lead across all geographies.<br/><br/>
Over the past year, our teams have delivered critical scopes across energy, infrastructure, and industrial sites while maintaining the highest standards of care and control. From high-risk brownfield environments to complex manufacturing ecosystems, our safety performance continues to reflect operational maturity and individual accountability at every level.

                   </p>
                 <p className='mb-3'><b >Key milestones include:</b></p>              
                  
                </div>
                <div className='col-md-6'>
                    <p className='mb-5'><b>2 million safe manhours</b> achieved on a major EPC assignment for a leading national energy company in the UAE - completed without a single Lost Time Incident.</p>
                    <p className='mb-5'><b>3 million safe manhours</b> recorded on a complex multi-stakeholder (Petrofac and a leading national energy company) construction project in the UAE, with 20 site professionals formally recognized for HSE leadership</p>
               <p className='mb-5'>In<b> Pakistan</b>, the <b>K-IV infrastructure project</b> and the <b>EPCL shutdown site</b> each surpassed <b>2 million and 1.7 million safe manhours</b> respectively, reinforcing a strong culture of safety and execution discipline</p>
                <p className='mb-5'> In <b>Qatar</b>, teams celebrated <b>1 million safe manhours</b> on a critical energy construction project, demonstrating consistency in safety leadership across borders</p>
                </div>
                 <div className='col-md-6'>
                     <p className='mb-5'>At our <b>Lahore Manufacturing Works</b>, the team celebrated <b>13 million safe manhours</b>, a reflection of deeply embedded safety systems and daily discipline</p>
                    <p className='mb-5'>A Descon team member in Qatar exercised <b>Stop Work Authority</b> to prevent a potential hazard, earning formal appreciation from site leadership</p>
                 <p className='mb-5'>In Pakistan, our shutdown execution team at <b>PARCO</b> was recognized for achieving <b>2.5 million safe manhours</b> across a critical shutdown project</p>
                 <p className='mb-5'>We also successfully completed our IMS recertification audit for ISO 45001, 9001, and 14001 - with zero non-conformances, reaffirming the strength of our systems in health, safety, quality, and environment</p>
                 </div>
                
                <div className='col-12'>
                          <p>These are not just milestones. They are reminders that safety is not the job of a few. It is the responsibility of all, and the reason we go home safe every day.</p>

                </div>
            </div>
            <div className="row">
        <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/hse-1.png" alt="HSE 1" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
        <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/hse-2.png" alt="HSE 2" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
        <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/hse-3.png" alt="HSE 3" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
        <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/hse-4.png" alt="HSE 4" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>

        <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/hse-5.png" alt="HSE 5" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
        <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/hse-6.png" alt="HSE 6" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
        <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/hse-7.png" alt="HSE 7" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
        <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/hse-8.png" alt="HSE 8" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
         <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/hse-9.png" alt="HSE 8" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
         <div className="col-6 col-md-3 mb-4">
          <Image src="/assets/client-newsletter/hse-10.png" alt="HSE 8" className="img-fluid rounded" width={300} height={200} layout="responsive" />
        </div>
      </div>
     
      <style jsx>{`
        br {
         display:block !important
        }
      `}</style>
        </div>
    )
}

export default Qhseintro