import Image from 'next/image';
import React from 'react'
import Carousel from 'react-multi-carousel';
import 'react-multi-carousel/lib/styles.css';


const DelOwelcarousel = () => {
    const responsive = {
        superLargeDesktop: {
            // the naming can be any, depends on you.
            breakpoint: { max: 4000, min: 3000 },
            items: 3
        },
        desktop: {
            breakpoint: { max: 3000, min: 991 },
            items: 3
        },
        tablet: {
            breakpoint: { max: 991, min: 464 },
            items: 2
        },
        mobile: {
            breakpoint: { max: 991, min:0 },
            items: 1
        }
    };
    return (
        <>
            <div className='carousel testimonial-content'>
                <Carousel
                className='py-4 carousel-with-dots'
                    showDots={true}
                    responsive={responsive}
                    infinite={true}
                    arrows={false} renderButtonGroupOutside={true}
                >
                   
                   <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/stuart-park.jpg' width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>Descon&apos;s dedication to diversity and inclusion shines through in all we do. We embrace unique perspectives and foster a welcoming environment. Our team&apos;s expertise and commitment to continuous learning drive efficient project completion, while our stringent safety protocols ensure employee wellbeing.</p>
                            <div className="card-footer">
                                <h5 className="card-title text-dark">Steven Suykens</h5>
                                <small className="text-dark">Head of Operations <span>Descon Engineering</span> </small>
                            </div>
                        </div>
                    </div>
                    <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/iqra.jpg' width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>Descon has provided me with hands-on experience in the field, exposure to a wide range of projects, and the chance to work with some of the most talented professionals in the industry.</p>
                            <div className="card-footer ">
                                <h5 className="card-title text-dark">Iqra Khaliq</h5>
                                <small className="text-dark font-weight-bold">Engineer PMC <span>Descon Engineering</span></small>
                            </div>
                        </div>
                    </div>
                  
                    <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/syeda-bina.png' width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>The working environment offered here is very good with a perfect work life balance. But the best thing about Descon is its vast exposure in different fields and the fact that there is so much to explore that one can never get bored!</p>
                            <div className="card-footer">
                                <h5 className="card-title text-dark">Syeda Beena Fatima</h5>
                                <small className="text-dark">PMT Engineer <span>Descon Engineering</span></small>
                            </div>
                        </div>
                    </div>
                   
                   
                  
                </Carousel>
            </div>
        </>
    )
}

export default DelOwelcarousel
