import Image from 'next/image';
import React from 'react'
import Carousel from 'react-multi-carousel';
import 'react-multi-carousel/lib/styles.css';


const Owelcarousel = () => {
    const responsive = {
        superLargeDesktop: {
            // the naming can be any, depends on you.
            breakpoint: { max: 4000, min: 3000 },
            items: 3
        },
        desktop: {
            breakpoint: { max: 3000, min: 991 },
            items: 3
        },
        tablet: {
            breakpoint: { max: 991, min: 464 },
            items: 1
        },
        mobile: {
            breakpoint: { max: 991, min:0 },
            items: 1
        }
    };
    return (
        <>
            <div className='carousel testimonial-content'>
                <Carousel
                className='py-4 carousel-with-dots'
                    showDots={true}
                    responsive={responsive}
                    infinite={true}
                    arrows={false} renderButtonGroupOutside={true}
                >
                   
                   <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/stuart-park.jpg'  width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>Descon&apos;s dedication to diversity and inclusion shines through in all we do. We embrace unique perspectives and foster a welcoming environment. Our team&apos;s expertise and commitment to continuous learning drive efficient project completion, while our stringent safety protocols ensure employee wellbeing.</p>
                            <div className="card-footer">
                                <h5 className="card-title text-dark">Steven Suykens</h5>
                                <small className="text-dark">Head of Operations <span>Descon Engineering</span> </small>
                            </div>
                        </div>
                    </div>
                   
                   
                    <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/rabia-shoib.png'  width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>Descon offers a culture that embraces flexibility, diversity of thought and an environment that makes it easier to come to work.</p>
                            <div className="card-footer ">
                                <h5 className="card-title text-dark">Rabia Shoaib</h5>
                                <small className="text-dark font-weight-bold">Head Of Finance <span>Descon Oxychem</span></small>
                            </div>
                        </div>
                    </div>
                  
                    <div className="card h-100">
                        <div className='position-relative'>
                            <Image src='/assets/adil-akbar.png'  width={361} height={202} layout='responsive' className="card-img-top product--image " alt="Rectangle72" />
                            <div className='imgborder'></div>
                            <div className='bg-comas'>
                                <Image src='/assets/quotation.png'  width={100} height={10} alt='comos' />
                            </div>
                        </div>
                        <div className="card-body">
                            <p className="card-text" style={{ letterSpacing: "0px", fontWeight: "bold", fontSize: "15px", marginTop: "20px" }}>Clocking into a job that gives me autonomy to do things my way is what makes me enjoy this place.</p>
                            <div className="card-footer">
                                <h5 className="card-title text-dark">Adil Akbar</h5>
                                <small className="text-dark">Regional Sales Manager (North) <span>Descon Oxychem</span></small>
                            </div>
                        </div>
                    </div>
                  
                </Carousel>
            </div>
        </>
    )
}

export default Owelcarousel
