import Image from 'next/image'
import Link from 'next/link'
import React from 'react'


const Strategyintro = () => {
    return (
        <div className='container-fluid'>
            <div className='row mb-5'>
                <div className='col-12'>
                <p className='biggerfont' >Strategy</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                    <div className='img-fluid image4'  style={{ zIndex: "2" }}>
                        <Image src='/assets/image4.png' alt='Strategy' width={940} height={560} layout='responsive' className='img-fluid' />
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6   col-12 text-hse my-auto panel-right-adjust'>
                    <h1>HSE Strategy</h1>
                    <p>Our strategy aims to reduce work related incidents with specific emphasis on safe company operations at all the geographies we are working in. We believe in taking proactive measures to prevent people from health, safety, and environmental risks.</p>
                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12 '>
                <p className='biggerfont text-end' >Commitment</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                    <h1>Our Commitment to Safety</h1>
                    <p>
                    At Descon, we prioritize the health, safety, and environmental (HSE) practices that go beyond mere compliance. We strive for continuous improvement by fostering leadership commitment, implementing robust HSE management systems, and encouraging the dedication of our workforce.<br/><br/>
Safety is at the core of our operations, and we have integrated a comprehensive range of programs into our operational management systems. Our HSE management system serves as a centralized framework, ensuring the consistent implementation of HSE standards across all company operations in accordance with the requirements of ISO 45001 and ISO 14001.<br/><br/>
To strengthen our safety culture, we have appointed a Chief HSE Officer (CHSEO) who oversees HSE practices. Additionally, regular HSE Steering Committee Meetings, attended by senior management including the CEO are conducted to address safety concerns, promote health initiatives, and cultivate a strong HSE culture.


                    </p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image5' style={{ zIndex: "2" }}>
                        <Image src='/assets/committment.jpg' width={940} height={560} layout='responsive' alt='committment'  className='img-fluid' />
                    </div>
                </div>
                
            </div>
            <div className='row mb-5'>
                <div className='col-12'>
                <p className='biggerfont' >New Ways</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                    <div className='img-fluid image4' style={{ zIndex: "2" }}>
                        <Image src='/assets/adopting.jpg' width={940} height={560} layout='responsive' alt='adopting'  className='img-fluid' />
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 text-hse my-auto panel-right-adjust'>
                    <h1>Adopting New Ways of Working</h1>
                    <p>
                        To streamline our HSE operations, we have implemented a SAS-based customized software called ProAACT. This software enables us to record and manage all HSE data and events efficiently. Audits and associated action items are seamlessly handled through the system, enhancing the overall effectiveness of our HSE practices.<br/><br/>
Furthermore, our mobile application, integrated with the main HSE database, empowers our employees to promptly report safety observations, near misses, and incidents. The application sends notifications to the leadership, alerting them based on the severity level of the reported incidents. This real-time reporting system enables swift response and proactive measures to ensure a safe working environment.

                    </p>
                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12 '>
                <p className='biggerfont text-end' >Certificate</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                  <div className='row'>
                    <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                       <div className='pdfspacer text-center'>
                       <Link  target='_blank' href='/assets/qhse/descon-engineering-limited-qms-certificate-9001.PDF'>
                       <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151}  layout='responsive' />
                       <p className='mb-2'>Descon Engineering Limited - QMS Certificate 9001</p>
                       <p className=' text-danger'>File Size: 1.9 MB</p>
                       </Link>
                       </div>
                    </div>
                    <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                       <div className='pdfspacer text-center'>
                       <Link  target='_blank' href='/assets/qhse/descon-engineering-limited-ohsms-certificate-45001.PDF'>
                       <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151}  layout='responsive'  />
                       <p className='mb-2'>Descon Engineering Limited - OHSMS Certificate 45001</p>
                       <p className=' text-danger'>File Size: 1.9 MB</p>
                       </Link>
                       </div>
                    </div>
                    <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                       <div className='pdfspacer text-center'>
                       <Link  target='_blank' href='/assets/qhse/descon-engineering-limited-ems-certificate-14001.PDF'>
                       <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151}  layout='responsive' />
                       <p className='mb-2'>Descon Engineering Limited- EMS Certificate 14001</p>
                       <p className=' text-danger'>File Size: 1.9 MB</p>
                       </Link>
                       </div>
                    </div>
                    <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                       <div className='pdfspacer text-center'>
                       <Link  target='_blank' href='/assets/qhse/hse-policy.pdf'>
                       <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151}  layout='responsive' />
                       <p className='mb-2'>Health, Safety, Environment and Well Being Policy-Rev 04</p>
                       <p className=' text-danger'>File Size: 0.07 MB</p>
                       </Link>
                       </div>
                    </div>
                    <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                       <div className='pdfspacer text-center'>
                       <Link  target='_blank' href='/assets/qhse/quality-policy.pdf'>
                       <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151}  layout='responsive' />
                       <p className='mb-2'>Quality Policy</p>
                       <p className=' text-danger'>File Size: 0.1 MB</p>
                       </Link>
                       </div>
                    </div>
                    
                    
                </div>  
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image5' style={{ zIndex: "2" }}>
                        <Image src='/assets/certificate.jpg' alt='certificate'  className='img-fluid' width={151} height={151}  layout='responsive' />
                    </div>
                </div>
                
            </div>
            
            
        </div>
    )
}

export default Strategyintro