import React from 'react'
import Link from 'next/link';
import Image from 'next/image';

const Loginform = () => {
    return (
        <div className='mt-5 mb-5'>
            <div className="container ">
                <div className="row justify-content-around">
                    <div className="col-lg-6 col-12 col-md-12 mt-5">
                        <h1 className='fw-bold text-dark mt-5'>
                            Login Now
                        </h1>
                        <p className='text-muted mt-3'>Please use your credentials to login to Descons Career Portal</p>
                        <div className="row mt-5">
                            <div className="mb-3">
                                <label for="exampleFormControlInput1" className="form-label">Email address</label>
                                <input type="email" className="form-control form-control-lg" id="exampleFormControlInput1" placeholder="name@example.com" />
                            </div>
                            <div className="mb-3">
                                <label for="exampleFormControlInput1" className="form-label">Password</label>
                                <input type="password" className="form-control form-control-lg" id="exampleFormControlInput1" placeholder="name@example.com" />
                            </div>
                            <div className="row justify-content-between">
                                <div className="col-lg-6 col-md-6 col-12">
                                    <div className="form-check">
                                        <input className="form-check-input" type="checkbox" value="" id="flexCheckDefault" />
                                        <label className="form-check-label" for="flexCheckDefault">
                                            Remember for 30 days
                                        </label>
                                    </div>
                                </div>
                                <div className="col-lg-3 col-md-3 col-12">
                                   <Link   href='#' className='text-decoration-none fw-bold' >Forget Password</Link> 
                                </div>
                                <div className='mt-5 mb-3'>
                                    <div className="container ">
                                        <div className="row justify-content-around">
                                            <div className="col-lg-6 col-12 col-md-12">
                                                <div className="d-grid gap-2">
                                                    <button className="btn" type="button" style={{ backgroundColor: "#0066B3", color: "white" }}>Login</button>
                                                </div>
                                            </div>
                                            <div className="col-lg-6 col-12 col-md-12 text-center p-3">
                                               <p className="text-muted">Dont Have an account? <Link   href='/register' className='text-decoration-none fw-bold'>Signup Now</Link> </p> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div className="container text-center">
                                <div className="row align-items-start">
                                    <div className="col">
                                        <hr/>
                                    </div>
                                    <div className="col">
                                        <p className="text-capitalize"> or continue with </p>

                                    </div>
                                    <div className="col">
                                        <hr />
                                    </div>
                                </div>
                            </div>
                            <div>
                                <div className="container ">
                                    <div className="row justify-content-around ">
                                        <div className="col-lg-6 col-12 col-md-12 p-2">
                                            <div className="d-grid gap-2">
                                                <button className="btn " type="button" style={{ backgroundColor: "#0066B3", color: "white" }}>Signin with LinkedIn</button>
                                            </div>
                                        </div>
                                        <div className="col-lg-6 col-12 col-md-12 text-center p-2">
                                            <div className="d-grid gap-2">
                                                <button className="btn" type="button" style={{ backgroundColor: "#0066B3", color: "white" }}>Signin with Google</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className="col-lg-4 col-12 col-md-12 mt-5 ">
                        <div className='borderimg'>
                        </div>
                        <Image src='/assets/Rectangle 67.png' alt='login' className='mt-5' width={500} height={500}/>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default Loginform
