import React from 'react'
import Link from 'next/link'
import Image from 'next/image'

const Ourinvestments = () => {
    return (
        <>
            <div className='container fullwidth p-3 spacer'>
                <div className='row '>
                    <p className='agrisubtitle'>Descon Capital</p>
                    <h4 className="agrititle">Our Investments</h4>
                    <div className='col-md-4 col-12 mb-4'>
                        <div className='card border border-primary border-2' >
                            <div className='card-image'>
                                <Image src='/assets/investment/skardu.png' alt="Snow" className='img-fluid' width={355} height={146} />
                            </div>
                        </div>
                        <div className="card-body mt-4">
                            <h5 className="card-title fw-bold fs-6 text-dark">HIMMEL SKARDU</h5>
                            <p className="card-text mt-2" style={{ lineHeight: "1.3rem" }}>Nature&apos;s masterpiece meets modern marvel. Himmel Skardu by Luxus offers 5-star amenities alongside the untamed beauty of the Shigar River and Himalayan giants.</p>
                        </div>
                    </div>

                    <div className='col-md-4 col-12 mb-4'>
                        <div className='card border border-primary border-2' >
                            <div className='card-image'>
                                <Image src='/assets/investment/The-Rihla-Hunza.jpg' alt="Snow" className='img-fluid' width={355} height={146} />

                            </div>
                        </div>
                        <div className="card-body mt-4">
                            <h5 className="card-title fw-bold fs-6 text-dark">THE RIHLA HUNZA</h5>
                            <p className="card-text mt-2" style={{ lineHeight: "1.3rem" }}>Welcome to Grand Rihla in Hunza, where luxury and comfort harmonize with the awe-inspiring beauty of the Hunza Valley, offering an unforgettable retreat.</p>
                        </div>
                    </div>


                    <div className='col-md-4 col-12 mb-4'>
                        <div className='card border border-primary border-2' >
                            <div className='card-image'>
                            <Link className='text-decoration-none' href='https://eqraz.com/' target="_blank">
                                <Image src='/assets/investment/eqraz.png' alt="Snow" className='img-fluid' width={355} height={146} />
                                </Link>
                            </div>
                        </div>
                        <div className="card-body mt-4">
                            <h5 className="card-title fw-bold fs-6 text-dark">EQRAZ INC.</h5>
                            <p className="card-text mt-2" style={{ lineHeight: "1.3rem" }}>
                            Founded in Toronto, Canada in 2020, EQRAZ Inc. is dedicated to the cause of expanding &quot;Islamic Finance&quot; throughout North America. EQRAZ is working with &quot;best-in-their-class&quot; industry partners to provide an institutional-quality offering to its clients, with innovative interest-free financing products being offered for the first time in North America, a world-class client-service infrastructure through partnership with one of Canada&apos;s primary mortgage administration firms, and a carefully selected mortgage broker network to ensure client&apos;s needs are understood and catered for.
                            </p>
                        </div>
                    </div>

                    <div className='col-md-4 col-12 mb-4'>
                        <div className='card border border-primary border-2' >
                            <div className='card-image'>
                            <Link className='text-decoration-none' href='https://conaturalintl.com/' target="_blank">
                                <Image src='/assets/investment/conatural3.jpg' alt="Snow" className='img-fluid' width={355} height={146} />
                                </Link>
                            </div>
                        </div>
                        <div className="card-body mt-4">
                                <Image src='/assets/investment/logo.png' alt="Snow" className='img-fluid' width={5} height={1} style={{width:"200px"}} />
                            <p className="card-text mt-2" style={{ lineHeight: "1.3rem" }}>Conatural is a Pakistani brand that offers natural and organic hair and skin care products made from certified organic ingredients. The brand is committed to creating high-quality, natural products that are safe and effective.</p>
                        </div>
                    </div>
                </div>
            </div>
        </>
    )
}

export default Ourinvestments
