import React, { useState } from 'react';
import { Tab, Nav } from 'react-bootstrap';
import Engines from './engines';
import Suger from './suger';
import Thermal from './thermal';
import Wind from './wind';

function Projectstap() {
    const [activeTab, setActiveTab] = useState('tab1');

    const handleTabSelect = (eventKey) => {
        setActiveTab(eventKey);
    };

    return (
        <div className='container'>
            <div className='row'>
                <div className='col-lg-12 col-12 mx-auto mt-5'>
                    <Tab.Container activeKey={activeTab} onSelect={handleTabSelect}>
                        <Nav variant="tabs" className='mediatabs'>
                            <Nav.Item>
                                <Nav.Link eventKey="tab1">Thermal</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link eventKey="tab2">Wind</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link eventKey="tab3">Sugar</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link eventKey="tab4">Reciprocating Engines</Nav.Link>
                            </Nav.Item>
                        </Nav>
                        <Tab.Content>
                            <Tab.Pane eventKey="tab1">
                                <Thermal />
                            </Tab.Pane>
                            <Tab.Pane eventKey="tab2">
                                <Wind/>
                            </Tab.Pane>
                            <Tab.Pane eventKey="tab3">
                                <Suger/>
                            </Tab.Pane>
                            <Tab.Pane eventKey="tab4">
                                <Engines/>
                            </Tab.Pane>
                        </Tab.Content>
                    </Tab.Container>
                </div>
            </div>
        </div>
    );
}

export default Projectstap;