import React from 'react'
import { Tab, Nav } from 'react-bootstrap';
import Videos from '../../components/media/videos';
import Head from 'next/head';
import Headingmedia from '../../components/media/headingmedia';
import Mediaintro from '../../components/media/mediaintro';
import Layoutdps from '../_layoutdps';



const Projects = () => {
    return (
        <>
            <Head>
                <title>Descon Power Solutions - Projects  | Descon</title>
                <meta name="description" content="To enhance its expertise, Descon Power Solutions has partnered with industry leaders like GE, Nordex," key="desc" />
                <meta property="og:title" content="Descon Power Solutions - Projects" />
                <meta property="og:description" content="To enhance its expertise, Descon Power Solutions has partnered with industry leaders like GE, Nordex," />
                <meta property="og:image" content="/media.jpg" />
            </Head>
            <Layoutdps>
                <Headingmedia />
                <Mediaintro />
                <div className='container'>
                    <div className='row'>
                        <div className='col-lg-12 col-12 mx-auto mt-5'>
                            <Tab.Container >
                                <Nav variant="tabs" className='mediatabs'>
                                    <Nav.Item>
                                        <Nav.Link eventKey="tab1">News & Events</Nav.Link>
                                    </Nav.Item>
                                    <Nav.Item>
                                        <Nav.Link eventKey="tab2">Newsletter</Nav.Link>
                                    </Nav.Item>
                                    <Nav.Item>
                                        <Nav.Link eventKey="tab3">Videos</Nav.Link>
                                    </Nav.Item>
                                </Nav>
                                <Tab.Content>
                                    <Tab.Pane eventKey="tab1" >
                                        <div className='mt-5 pb-5'>
                                            <div className='mt-5 pb-5'>
                                                <div className="container--fluid">
                                                    <div className="row row-cols-1 row-cols-md-3 g-3" >
                                                        {/* <NewsCard /> */}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </Tab.Pane>
                                    <Tab.Pane eventKey="tab2">
                                        <div className='mt-5 pb-5'>
                                            <div className="container">
                                                <div className="row d-none">
                                                    <div className="col-4">
                                                        <input type="text" placeholder="Search.." />
                                                    </div>
                                                </div>
                                            </div>

                                            <div className="container-fluid">
                                                <div className="row row-cols-1 row-cols-md-3 g-3" >
                                                    {/* <Lettercard /> */}
                                                </div >
                                            </div>
                                        </div >
                                    </Tab.Pane>
                                    <Tab.Pane eventKey="tab3">
                                        <Videos />
                                    </Tab.Pane>
                                </Tab.Content>
                            </Tab.Container>
                        </div>
                    </div>
                </div>
            </Layoutdps>
        </>
    );
};


export default Projects