import Link from 'next/link';
import React, { useState } from 'react';
import { Tab, Nav } from 'react-bootstrap';
import Internationaldis from './internationaldis';
import Nationaldis from './nationaldis';

const Distributortap = () => {
    const [activeTab, setActiveTab] = useState('tab1');

    const handleTabSelect = (eventKey) => {
        setActiveTab(eventKey);
    };
    return (
        <div className='container'>
            <div className='row'>
                <div className='col-lg-12 col-12 mt-5'>
                    <Tab.Container activeKey={activeTab} onSelect={handleTabSelect}>
                        <Nav variant="tabs" className='mediatabs'>
                            <Nav.Item>
                                <Nav.Link eventKey="tab1">National Distributors</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link eventKey="tab2">International Distributors</Nav.Link>
                            </Nav.Item>
                        </Nav>
                        <Tab.Content>
                            <Tab.Pane eventKey="tab1">
                                <Nationaldis />
                            </Tab.Pane>
                            <Tab.Pane eventKey="tab2">
                                <Internationaldis />
                            </Tab.Pane>
                        </Tab.Content>
                    </Tab.Container>
                </div>
            </div>
        </div>
    )
}
export default Distributortap