import Image from 'next/image'
import Link from 'next/link'
import React, { useState } from 'react'


const Strategyintro = () => {
    const [expanded, setExpanded] = useState(false);

    const toggleExpand = () => {
        setExpanded(!expanded);
    };


    const text = "Highest Standards of Performance & Business Excellence: The company adheres to the highest standards for the safe operation of its facilities and the protection of its environment, employees, customers and the people of the communities in which it conducts business. Security will be managed as safety.<br/><br/> We will strengthen our businesses by making quality, health and environmental issues an integral part of all business activities, and by continuously striving to align our businesses with public expectations.<br/><br/> Committed to Zero Lost Time Injuries, Illnesses, and Incident: The company believes that all injuries and occupational illnesses, as well as safety and environmental incidents, are preventable, and is committed to a goal of zero for all of them. We will promote off-the-job safety for our employees. We will assess the environmental impact of our facilities, and transportation equipment so these are safe, secure and acceptable to local communities and protect the environment.<br/><br/> We will be prepared for emergencies and will provide leadership to assist our local communities to improve their emergency preparedness.<br/><br/> Goal of Zero Waste and Emissions: The organization will drive toward minimal waste generation at the source. Currently, it meets all criteria established by the Notional Environmental Quality Standards (NEQS). Materials will be reused and recycled to minimize the need for treatment or disposal, and to conserve resources. <br/><br/> Where waste is generated, it will be handled and disposed of safely and responsibly. Where any practice that has created conditions that require correction, we will responsibly correct them.<br/><br/> Continuously Improving Processes, Practices, and Products: The company will extract, make, use, handle, package, transport and dispose of its materials safely and in an environmentally responsible way. We will continuously analyze and improve our practices, processes and products, to reduce their risk and impact throughout the product life cycle. We will develop new products and processes that have increasing margins of safety for both human health and the environment. We will seek opportunities to make any new and existing facilities inherently safer. <br/><br/> We will work with our suppliers, carriers, distributors and customers to achieve similar product stewardship, and we will provide information and assistance to support their efforts to do so. <br/><br/> Open and Public Discussion, Influence on Public Policy: The company will promote open discussion with stakeholders about the materials it makes, uses and transports and the impacts of its activities on their health, safety and environment. <br/><br/> We will build alliances with the government, policymakers, businesses and advocacy groups to develop sound policies, laws and practices that improve quality, health, safety and the environment. <br/><br/> Management and Employee Commitment & Accountability: The Board of Directors, including the Chief Executive Officer, will be informed about pertinent health, safety and Environmental issues and will ensure that policies are in place and actions taken to achieve this commitment. Compliance with this commitment and applicable laws is the responsibility of every employee and contractor acting on our behalf and a condition of their employment or contract. <br/><br/> Management in our business is responsible for educating, training and motivating employees to understand and comply with this commitment and applicable laws. <br/><br/> We will deploy our resources, including research, development and capital, to meet this commitment and will do so in a manner that strengthens our businesses. <br/><br/> The company will measure and regularly report to the public, its progress in meeting this commitment. <br/><br/>"


    return (
        <div className='container-fluid'>
            <div className='row mb-5'>
                <div className='col-12 mt-5 '>
                    <p className='biggerfont text-end' >Vision</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                    <h1>HSE Vision</h1>
                    <p>
                        Through our commitment to quality, health, safety and environmental excellence (QHSE), we affirm to all our stakeholders, including our employees, customers, shareholders, and the public, that we will work collaboratively to bring sustainable, market-driven and innovative solutions to solve some of the significant challenges, making lives better, safer, and healthier. We will implement those strategies that build successful businesses and achieve the greatest benefit for all our stakeholders with respect and care for the environment, without compromising the ability of future generations to meet their needs.
                    </p>
                    <p>
                        We will continuously improve our practices in light of advances in technology and new understandings in quality, health, safety and environmental science. We will make consistent, measurable progress in implementing this commitment throughout our business operations to achieve this commitment.
                    </p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image4' style={{ zIndex: "2" }}>
                        <Image src='/assets/dol/qhse/vision-img.jpg' width={940} height={560} layout='responsive' alt='committment' className='img-fluid' />
                    </div>
                </div>

            </div>
            <div className='row mb-5'>
                <div className='col-12'>
                    <p className='biggerfont' >Commitment</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 position-relative panel-left-adjust'>
                    <div className='img-fluid image4' style={{ zIndex: "2" }}>
                        <Image src='/assets/dol/qhse/commitment-img.jpg' width={940} height={560} layout='responsive' alt='adopting' className='img-fluid' />
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6 col-12 text-hse my-auto panel-right-adjust'>
                    <h1>HSE Commitment</h1>
                    {expanded ? (
                        <p dangerouslySetInnerHTML={{ __html: text }} />
                    ) : (
                        <p dangerouslySetInnerHTML={{ __html: text.slice(0, 1000) + '...' }} />
                    )}
                    <button className="button-more read" onClick={toggleExpand}>
                        {expanded ? 'Reduce text' : 'Continue Reading'}
                    </button>
                </div>
            </div>
            <div className='row mb-5'>
                <div className='col-12 '>
                    <p className='biggerfont text-end' >Certificates</p>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12  col-12 text-hse my-auto panel-leftright-adjust order-2 order-xl-1'>
                    <div className='row'>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dol/qhse/un-120388-0001-rev.00.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>UN 120388 0001 Rev.00</p>
                                    <p className=' text-danger'>File Size: 241 KB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dol/qhse/descon-halal-certificate.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>Descon Halal Certificate</p>
                                    <p className=' text-danger'>File Size: 3.1 MB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dol/qhse/haccp.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>HACCP</p>
                                    <p className=' text-danger'>File Size: 2 MB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dol/qhse/iso-9001-2015.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>ISO-9001-2015</p>
                                    <p className=' text-danger'>File Size: 2 MB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dol/qhse/iso-14001-2015.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>ISO-14001-2015</p>
                                    <p className=' text-danger'>File Size: 2 MB</p>
                                </Link>
                            </div>
                        </div>
                        <div className='col-xl-4 col-lg-3 col-md-4  col-4 mb-4'>
                            <div className='pdfspacer text-center'>
                                <Link target='_blank' href='/assets/dol/qhse/ohsas-45001-2018.pdf'>
                                    <Image src='/assets/pdficon.png' className='img-fluid' alt="" width={151} height={151} layout='responsive' />
                                    <p className='mb-2'>OHSAS 45001-2018</p>
                                    <p className=' text-danger'>File Size: 2 MB</p>
                                </Link>
                            </div>
                        </div>
                    </div>
                </div>
                <div className='col-xxl-6 col-xl-6 col-lg-12 col-12 position-relative px-md-0 px-0 text-end order-1 order-xl-2'>
                    <div className='img-fluid image4' style={{ zIndex: "2" }}>
                        <Image src='/assets/dol/qhse/certificate-img.jpg' alt='certificate' className='img-fluid' width={151} height={151} layout='responsive' />
                    </div>
                </div>

            </div>


        </div>
    )
}

export default Strategyintro